/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.icons.DerivedImageIcon;

public class ReflectedIcon
extends DerivedImageIcon {
    private boolean leftToRight;

    public ReflectedIcon(Icon baseIcon, boolean leftToRight) {
        super(baseIcon);
        this.leftToRight = leftToRight;
    }

    @Override
    protected ImageIcon createImageIcon() {
        Icon sourceIcon = this.getSourceIcon();
        Image image = this.createImage();
        int width = sourceIcon.getIconWidth();
        int height = sourceIcon.getIconHeight();
        BufferedImage flippedImage = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)flippedImage.getGraphics();
        if (this.leftToRight) {
            graphics.drawImage(image, width, 0, -width, height, null);
        } else {
            graphics.drawImage(image, 0, height, width, -height, null);
        }
        graphics.dispose();
        return new ImageIcon(flippedImage, this.getFilename());
    }
}

