/*
 * Decompiled with CFR 0.152.
 */
package help.validator.location;

import ghidra.util.exception.AssertException;
import help.GHelpSet;
import help.validator.location.HelpModuleLocation;
import help.validator.model.GhidraTOCFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class JarHelpModuleLocation
extends HelpModuleLocation {
    private static final Pattern JAR_FILENAME_PATTERN = Pattern.compile(".*/(\\w*)\\.jar!/.*");
    private static Map<String, String> env = new HashMap<String, String>();

    private static FileSystem getOrCreateJarFS(File jar) {
        URI jarURI;
        try {
            jarURI = new URI("jar:file://" + jar.toURI().getRawPath());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Internal error", e);
        }
        try {
            return FileSystems.getFileSystem(jarURI);
        }
        catch (FileSystemNotFoundException e) {
            try {
                return FileSystems.newFileSystem(jarURI, env);
            }
            catch (IOException e1) {
                throw new RuntimeException("Unexpected error building help", e1);
            }
        }
    }

    public JarHelpModuleLocation(File file) {
        super(JarHelpModuleLocation.getOrCreateJarFS(file).getPath("/help", new String[0]));
    }

    @Override
    public boolean isHelpInputSource() {
        return false;
    }

    @Override
    public HelpSet loadHelpSet() {
        File jarFile = this.getJarFile();
        String moduleName = this.getModuleName(jarFile);
        Path hsPath = this.helpDir.resolve(moduleName + "_HelpSet.hs");
        try {
            return new GHelpSet(null, hsPath.toUri().toURL());
        }
        catch (MalformedURLException | HelpSetException e) {
            throw new AssertException("Pre-built help jar file is missing it's help set: " + this.helpDir, e);
        }
    }

    private File getJarFile() {
        String uriString = this.helpDir.toUri().toString();
        int start = uriString.indexOf("file:/");
        String chopped = uriString.substring(start);
        int end = chopped.indexOf("!");
        chopped = chopped.substring(0, end);
        return new File(chopped);
    }

    private String getModuleName(File jarFile) {
        String name = jarFile.getName();
        int dotIndex = name.indexOf(46);
        return name.substring(0, dotIndex);
    }

    @Override
    public Path getHelpModuleLocation() {
        File jarFile = this.getJarFile();
        String moduleName = this.getModuleName(jarFile);
        String fullPath = jarFile.getPath();
        int moduleNameStart = fullPath.indexOf(moduleName);
        int end = moduleNameStart + moduleName.length();
        String moduleString = fullPath.substring(0, end);
        Path modulePath = Paths.get(moduleString, new String[0]);
        return modulePath;
    }

    @Override
    public GhidraTOCFile loadSourceTOCFile() {
        return null;
    }

    static {
        env.put("create", "false");
    }
}

