/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.concept;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelIterator;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.concept.IterableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelIteratorInternal;
import agent.dbgmodel.jna.dbgmodel.concept.IIterableConcept;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelIterator;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.util.Msg;

public class IterableConceptImpl
implements IterableConceptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IIterableConcept jnaData;
    private ModelIterator iterator;
    private KeyStore metadata;

    public IterableConceptImpl(IIterableConcept jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public long getDefaultIndexDimensionality(ModelObject contextObject) {
        Pointer pContextObject = contextObject.getPointer();
        WinDef.ULONGLONGByReference pDimensionality = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetDefaultIndexDimensionality(pContextObject, pDimensionality));
        return pDimensionality.getValue().longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelIterator getIterator(ModelObject contextObject) {
        PointerByReference ppIndexers;
        Pointer pContextObject = contextObject.getPointer();
        WinNT.HRESULT hr = this.jnaData.GetIterator(pContextObject, ppIndexers = new PointerByReference());
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_BOUNDS)) {
            Msg.error((Object)this, (Object)"iterator out of bounds - check symbol path");
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_COM_EXC)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIModelIterator wrap = new WrapIModelIterator(ppIndexers.getValue());
        try {
            ModelIteratorInternal modelIteratorInternal = ModelIteratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelIteratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    public ModelIterator getIterator() {
        return this.iterator;
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metdata) {
        this.metadata = metdata;
    }
}

