/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class X86_32_ElfExtension
extends ElfExtension {
    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 3 && elf.is32Bit();
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "x86".equals(language.getProcessor().toString()) && language.getLanguageDescription().getSize() == 32;
    }

    public String getDataTypeSuffix() {
        return "_x86";
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        if (!this.canHandle(elfLoadHelper)) {
            return;
        }
        super.processGotPlt(elfLoadHelper, monitor);
        this.processX86Plt(elfLoadHelper, monitor);
    }

    private void processX86Plt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        ElfSectionHeader pltSection = elfHeader.getSection(".plt");
        if (pltSection == null || !pltSection.isExecutable()) {
            return;
        }
        ElfDynamicTable dynamicTable = elfHeader.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(ElfDynamicType.DT_PLTGOT)) {
            return;
        }
        Program program = elfLoadHelper.getProgram();
        Memory memory = program.getMemory();
        MemoryBlock pltBlock = memory.getBlock(pltSection.getNameAsString());
        if (pltBlock == null) {
            return;
        }
        Register ebxReg = program.getRegister("EBX");
        try {
            long pltgotOffset = elfHeader.adjustAddressForPrelink(dynamicTable.getDynamicValue(ElfDynamicType.DT_PLTGOT));
            pltgotOffset = elfLoadHelper.getDefaultAddress(pltgotOffset).getOffset();
            RegisterValue pltgotValue = new RegisterValue(ebxReg, BigInteger.valueOf(pltgotOffset));
            program.getProgramContext().setRegisterValue(pltBlock.getStart(), pltBlock.getEnd(), pltgotValue);
        }
        catch (ContextChangeException | NotFoundException e) {
            throw new AssertException("unexpected", e);
        }
    }
}

