/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.ActionContext;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionActionContext;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsProvider;
import ghidra.app.plugin.core.debug.gui.memory.RegionRow;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.app.services.DebuggerListingService;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerLegacyRegionsPanel
extends JPanel {
    final DebuggerRegionsProvider provider;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    private final AutoService.Wiring autoServiceWiring;
    private Trace currentTrace;
    private final RegionsListener regionsListener = new RegionsListener();
    protected final RegionTableModel regionTableModel;
    protected GhidraTable regionTable;
    private GhidraTableFilterPanel<RegionRow> regionFilterPanel;
    private DebuggerRegionActionContext myActionContext;

    protected static RegionRow getSelectedRegionRow(ActionContext context) {
        if (!(context instanceof DebuggerRegionActionContext)) {
            return null;
        }
        DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
        Set<RegionRow> regions = ctx.getSelectedRegions();
        if (regions.size() != 1) {
            return null;
        }
        return regions.iterator().next();
    }

    protected static Set<TraceMemoryRegion> getSelectedRegions(ActionContext context) {
        if (!(context instanceof DebuggerRegionActionContext)) {
            return null;
        }
        DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
        return ctx.getSelectedRegions().stream().map(r -> r.getRegion()).collect(Collectors.toSet());
    }

    protected void activatedSelectAddresses(DebuggerRegionActionContext ctx) {
        if (this.listingService == null) {
            return;
        }
        Set<TraceMemoryRegion> regions = DebuggerLegacyRegionsPanel.getSelectedRegions(ctx);
        if (regions == null) {
            return;
        }
        AddressSet sel = new AddressSet();
        for (TraceMemoryRegion s : regions) {
            sel.add(s.getRange());
        }
        ProgramSelection ps = new ProgramSelection((AddressSetView)sel);
        this.listingService.setCurrentSelection(ps);
    }

    public DebuggerLegacyRegionsPanel(DebuggerRegionsProvider provider) {
        super(new BorderLayout());
        this.provider = provider;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)provider.plugin, (Object)this);
        this.regionTableModel = new RegionTableModel(provider.getTool());
        this.regionTable = new GhidraTable((TableModel)((Object)this.regionTableModel));
        this.regionTable.setSelectionMode(2);
        this.add(new JScrollPane((Component)this.regionTable));
        this.regionFilterPanel = new GhidraTableFilterPanel((JTable)this.regionTable, (RowObjectTableModel)this.regionTableModel);
        this.add((Component)this.regionFilterPanel, "South");
        this.regionTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.myActionContext = new DebuggerRegionActionContext(provider, this.regionFilterPanel.getSelectedItems(), (GTable)this.regionTable);
            this.contextChanged();
        });
        this.regionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerLegacyRegionsPanel.this.navigateToSelectedRegion();
                }
            }
        });
        this.regionTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerLegacyRegionsPanel.this.navigateToSelectedRegion();
                }
            }
        });
        TableColumnModel columnModel = this.regionTable.getColumnModel();
        TableColumn startCol = columnModel.getColumn(RegionTableColumns.START.ordinal());
        startCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn endCol = columnModel.getColumn(RegionTableColumns.END.ordinal());
        endCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lenCol = columnModel.getColumn(RegionTableColumns.LENGTH.ordinal());
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
        int small = 100;
        TableColumn rCol = columnModel.getColumn(RegionTableColumns.READ.ordinal());
        rCol.setPreferredWidth(100);
        TableColumn wCol = columnModel.getColumn(RegionTableColumns.WRITE.ordinal());
        wCol.setPreferredWidth(100);
        TableColumn eCol = columnModel.getColumn(RegionTableColumns.EXECUTE.ordinal());
        eCol.setPreferredWidth(100);
        TableColumn vCol = columnModel.getColumn(RegionTableColumns.VOLATILE.ordinal());
        vCol.setPreferredWidth(100);
    }

    private void loadRegions() {
        this.regionTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceMemoryManager memoryManager = this.currentTrace.getMemoryManager();
        this.regionTableModel.addAllItems(memoryManager.getAllRegions());
    }

    public DebuggerRegionActionContext getActionContext() {
        return this.myActionContext;
    }

    boolean isContextNonEmpty(DebuggerRegionActionContext ctx) {
        return !ctx.getSelectedRegions().isEmpty();
    }

    private static Set<TraceMemoryRegion> getSelectedRegions(DebuggerRegionActionContext ctx) {
        if (ctx == null) {
            return null;
        }
        return ctx.getSelectedRegions().stream().map(r -> r.getRegion()).collect(Collectors.toSet());
    }

    protected void navigateToSelectedRegion() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.listingService != null && (value = this.regionTable.getValueAt(selectedRow = this.regionTable.getSelectedRow(), selectedColumn = this.regionTable.getSelectedColumn())) instanceof Address) {
            this.listingService.goTo((Address)value, true);
        }
    }

    public void setSelectedRegions(Set<TraceMemoryRegion> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((RegionTableModel)this.regionTableModel).getRow(arg_0), (GTable)this.regionTable, this.regionTableModel, this.regionFilterPanel);
    }

    public Collection<RegionRow> getSelectedRows() {
        return this.regionFilterPanel.getSelectedItems();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.setTrace(coordinates.getTrace());
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadRegions();
        this.contextChanged();
    }

    public void contextChanged() {
        this.provider.contextChanged();
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.regionsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.regionsListener);
    }

    private class RegionsListener
    extends TraceDomainObjectListener {
        public RegionsListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.ADDED, this::regionAdded);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.DELETED, this::regionDeleted);
        }

        private void objectRestored() {
            DebuggerLegacyRegionsPanel.this.loadRegions();
        }

        private void regionAdded(TraceMemoryRegion region) {
            DebuggerLegacyRegionsPanel.this.regionTableModel.addItem(region);
        }

        private void regionChanged(TraceMemoryRegion region) {
            DebuggerLegacyRegionsPanel.this.regionTableModel.updateItem(region);
        }

        private void regionDeleted(TraceMemoryRegion region) {
            DebuggerLegacyRegionsPanel.this.regionTableModel.deleteItem(region);
        }
    }

    protected static class RegionTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<RegionTableColumns, ObjectKey, RegionRow, TraceMemoryRegion> {
        public RegionTableModel(PluginTool tool) {
            super(tool, "Regions", RegionTableColumns.class, TraceUniqueObject::getObjectKey, RegionRow::new, RegionRow::getRegion);
        }
    }

    protected static enum RegionTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RegionTableColumns, RegionRow>
    {
        NAME("Name", String.class, RegionRow::getName, RegionRow::setName),
        LIFESPAN("Lifespan", Lifespan.class, RegionRow::getLifespan),
        START("Start", Address.class, RegionRow::getMinAddress),
        END("End", Address.class, RegionRow::getMaxAddress),
        LENGTH("Length", Long.class, RegionRow::getLength),
        READ("Read", Boolean.class, RegionRow::isRead, RegionRow::setRead),
        WRITE("Write", Boolean.class, RegionRow::isWrite, RegionRow::setWrite),
        EXECUTE("Execute", Boolean.class, RegionRow::isExecute, RegionRow::setExecute),
        VOLATILE("Volatile", Boolean.class, RegionRow::isVolatile, RegionRow::setVolatile);

        private final String header;
        private final Function<RegionRow, ?> getter;
        private final BiConsumer<RegionRow, Object> setter;
        private final Class<?> cls;

        private <T> RegionTableColumns(String header, Class<T> cls, Function<RegionRow, T> getter, BiConsumer<RegionRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> RegionTableColumns(String header, Class<T> cls, Function<RegionRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(RegionRow row) {
            return this.setter != null;
        }

        public void setValueOf(RegionRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(RegionRow row) {
            return this.getter.apply(row);
        }
    }
}

