/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsPlugin;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ObjectElementRow {
    private Map<String, ?> map;
    private TargetObject to;
    private String currentKey;

    public ObjectElementRow(TargetObject ref, DebuggerObjectsProvider provider) {
        this.to = ref;
        ((CompletableFuture)this.to.fetchAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).thenAccept(attributes -> {
            this.map = attributes;
        })).exceptionally(ex -> {
            DebuggerObjectsPlugin plugin = provider.getPlugin();
            plugin.objectError("Failed to fetch attributes");
            return null;
        });
    }

    public void setAttributes(Map<String, ?> attributes) {
        this.map = attributes;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("Accessor");
        if (this.map == null) {
            return keys;
        }
        for (String key : this.map.keySet()) {
            Object value = this.map.get(key);
            if (value instanceof TargetObject) {
                TargetObject t = (TargetObject)value;
                if (t instanceof TargetMethod) continue;
                keys.add(key);
                continue;
            }
            keys.add(key);
        }
        return keys;
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
    }

    public Object getValue() {
        if (this.currentKey.equals("Accessor")) {
            return this.getTargetObject().getName();
        }
        if (this.map == null) {
            return "";
        }
        Object value = this.map.get(this.currentKey);
        if (value instanceof TargetObject) {
            TargetObject obj = (TargetObject)value;
            Map attributes = obj.getCachedAttributes();
            if (attributes.containsKey("_value")) {
                return attributes.get("_value").toString();
            }
            if (attributes.containsKey("_display")) {
                return obj.getDisplay();
            }
        }
        return value == null ? "" : value;
    }

    public TargetObject getTargetObject() {
        return this.to;
    }
}

