/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.workflow;

import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerWorkflowService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.plugintool.util.PluginUtils;
import java.util.Set;

@PluginInfo(shortDescription="Debugger workflow service (proxy to front-end)", description="Manage automatic debugging actions and analysis", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, servicesProvided={DebuggerWorkflowService.class})
public class DebuggerWorkflowServiceProxyPlugin
extends Plugin
implements DebuggerWorkflowService {
    protected DebuggerWorkflowServicePlugin delegate;

    protected static DebuggerWorkflowServicePlugin getOrCreateFrontEndDelegate() {
        FrontEndTool frontEnd = AppInfo.getFrontEndTool();
        for (Plugin plugin : frontEnd.getManagedPlugins()) {
            if (!(plugin instanceof DebuggerWorkflowServicePlugin)) continue;
            return (DebuggerWorkflowServicePlugin)plugin;
        }
        try {
            DebuggerWorkflowServicePlugin plugin = (DebuggerWorkflowServicePlugin)PluginUtils.instantiatePlugin(DebuggerWorkflowServicePlugin.class, (PluginTool)frontEnd);
            frontEnd.addPlugin((Plugin)plugin);
            return plugin;
        }
        catch (PluginException e) {
            throw new AssertionError((Object)e);
        }
    }

    public DebuggerWorkflowServiceProxyPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.delegate = DebuggerWorkflowServiceProxyPlugin.getOrCreateFrontEndDelegate();
        this.delegate.pluginToolAdded(this.tool);
    }

    protected void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.pluginToolRemoved(this.tool);
        }
    }

    @Override
    public Set<DebuggerBot> getAllBots() {
        return this.delegate.getAllBots();
    }

    @Override
    public Set<DebuggerBot> getEnabledBots() {
        return this.delegate.getEnabledBots();
    }

    @Override
    public Set<DebuggerBot> getDisabledBots() {
        return this.delegate.getDisabledBots();
    }

    @Override
    public void enableBots(Set<DebuggerBot> actors) {
        this.delegate.enableBots(actors);
    }

    @Override
    public void disableBots(Set<DebuggerBot> actors) {
        this.delegate.disableBots(actors);
    }
}

