/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TraceGuestPlatformMappedRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.guest.TracePlatformManager;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Stream;

public final class DBTraceObjectRegisterSupport
extends Enum<DBTraceObjectRegisterSupport> {
    public static final /* enum */ DBTraceObjectRegisterSupport INSTANCE = new DBTraceObjectRegisterSupport();
    private static final TraceDomainObjectListener HANDLER;
    private static final /* synthetic */ DBTraceObjectRegisterSupport[] $VALUES;

    public static DBTraceObjectRegisterSupport[] values() {
        return (DBTraceObjectRegisterSupport[])$VALUES.clone();
    }

    public static DBTraceObjectRegisterSupport valueOf(String name) {
        return Enum.valueOf(DBTraceObjectRegisterSupport.class, name);
    }

    protected AddressSpace findRegisterOverlay(TraceObject object) {
        TraceObject container = object.queryCanonicalAncestorsTargetInterface(TargetRegisterContainer.class).findFirst().orElse(null);
        if (container == null) {
            return null;
        }
        String pathStr = container.getCanonicalPath().toString();
        Trace trace = object.getTrace();
        return trace.getMemoryManager().getOrCreateOverlayAddressSpace(pathStr, trace.getBaseAddressFactory().getRegisterSpace());
    }

    protected AddressSpace findRegisterOverlay(TraceObjectValue objectValue) {
        return this.findRegisterOverlay(objectValue.getParent());
    }

    protected void onValueCreatedTransferToPlatformRegister(TraceObjectValue registerValue, TracePlatform platform, String name, LazyValues lazy) throws RegisterValueException {
        Register register = platform.getLanguage().getRegister(name);
        if (register == null) {
            return;
        }
        Address hostAddr = platform.mapGuestToHost(register.getAddress());
        if (hostAddr == null) {
            return;
        }
        AddressSpace hostSpace = hostAddr.getAddressSpace();
        TraceMemoryManager mem = registerValue.getTrace().getMemoryManager();
        long minSnap = registerValue.getMinSnap();
        if (hostSpace.isMemorySpace()) {
            mem.getMemorySpace(hostSpace, true).setValue(platform, minSnap, new RegisterValue(register, lazy.getValue()));
        } else if (hostSpace.isRegisterSpace()) {
            AddressSpace overlay = this.findRegisterOverlay(registerValue);
            if (overlay == null) {
                return;
            }
            mem.getMemorySpace(overlay, true).setValue(platform, minSnap, new RegisterValue(register, lazy.getValue()));
        } else {
            throw new AssertionError();
        }
    }

    protected void transferValueToPlatformRegister(TraceObjectValue registerValue, TracePlatform platform, TraceMemorySpace mem, Register register) {
        LazyValues lazy = new LazyValues(registerValue);
        try {
            mem.setValue(platform, registerValue.getMinSnap(), new RegisterValue(register, lazy.getValue()));
        }
        catch (RegisterValueException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
        }
    }

    protected String getRegisterName(TraceObject registerObject) {
        String name = registerObject.getCanonicalPath().key();
        if (PathUtils.isIndex((String)name)) {
            return PathUtils.parseIndex((String)name);
        }
        return name;
    }

    protected void onSpaceAddedCheckTransferObjectToPlatformRegister(TraceObject registerObject, TracePlatform platform, TraceMemorySpace mem) {
        String name = this.getRegisterName(registerObject);
        Register register = platform.getLanguage().getRegister(name);
        if (register == null || !register.getAddressSpace().isRegisterSpace()) {
            return;
        }
        for (TraceObjectValue traceObjectValue : DBTraceObjectRegisterSupport.it(registerObject.getOrderedValues(Lifespan.ALL, "_value", true))) {
            this.transferValueToPlatformRegister(traceObjectValue, platform, mem, register);
        }
    }

    protected void onSpaceAddedCheckTransferToPlatformRegisters(TracePlatform platform, TraceObject regContainer, TraceMemorySpace mem) {
        for (TraceObjectValPath traceObjectValPath : DBTraceObjectRegisterSupport.it(regContainer.querySuccessorsTargetInterface(Lifespan.ALL, TargetRegister.class, true))) {
            TraceObject registerObject = traceObjectValPath.getDestination(platform.getTrace().getObjectManager().getRootObject());
            this.onSpaceAddedCheckTransferObjectToPlatformRegister(registerObject, platform, mem);
        }
    }

    protected TraceMemorySpace getMemorySpace(TraceObject object, TraceLabelSymbol label) {
        Address hostAddr = label.getAddress();
        AddressSpace hostSpace = hostAddr.getAddressSpace();
        TraceMemoryManager mem = label.getTrace().getMemoryManager();
        if (hostSpace.isMemorySpace()) {
            return mem.getMemorySpace(hostSpace, true);
        }
        if (hostSpace.isRegisterSpace()) {
            AddressSpace overlay = this.findRegisterOverlay(object);
            return mem.getMemorySpace(overlay, true);
        }
        throw new AssertionError();
    }

    protected void transferRegisterValueToLabel(TraceObjectValue registerValue, TraceLabelSymbol label, byte[] value) {
        TraceMemorySpace mem = this.getMemorySpace(registerValue.getParent(), label);
        Address hostAddr = label.getAddress();
        long minSnap = registerValue.getMinSnap();
        Address address = mem.getAddressSpace().getOverlayAddress(hostAddr);
        mem.putBytes(minSnap, address, ByteBuffer.wrap(value));
    }

    protected static <T> Iterable<T> it(Stream<T> stream) {
        return () -> stream.iterator();
    }

    protected void transferRegisterObjectToLabel(TraceObject registerObject, TraceLabelSymbol label, boolean isBigEndian) {
        TraceMemorySpace mem = this.getMemorySpace(registerObject, label);
        Address address = mem.getAddressSpace().getOverlayAddress(label.getAddress());
        for (TraceObjectValue traceObjectValue : DBTraceObjectRegisterSupport.it(registerObject.getOrderedValues(label.getLifespan(), "_value", true))) {
            LazyValues lazy = new LazyValues(traceObjectValue);
            try {
                long minSnap = traceObjectValue.getMinSnap();
                mem.putBytes(minSnap, address, ByteBuffer.wrap(lazy.getBytes(isBigEndian)));
            }
            catch (RegisterValueException e) {
                Msg.error((Object)((Object)this), (Object)e.getMessage());
            }
        }
    }

    public void onValueCreatedTransfer(TraceObjectValue registerValue) throws RegisterValueException {
        TraceNamespaceSymbol nsRegMapLE;
        TraceObject registerObject = registerValue.getParent();
        Trace trace = registerValue.getTrace();
        LazyValues lazy = new LazyValues(registerValue);
        String name = this.getRegisterName(registerObject);
        TracePlatformManager platformManager = trace.getPlatformManager();
        this.onValueCreatedTransferToPlatformRegister(registerValue, platformManager.getHostPlatform(), name, lazy);
        for (TracePlatform tracePlatform : platformManager.getGuestPlatforms()) {
            this.onValueCreatedTransferToPlatformRegister(registerValue, tracePlatform, name, lazy);
        }
        TraceNamespaceSymbolView namespaces = trace.getSymbolManager().namespaces();
        TraceNamespaceSymbol traceNamespaceSymbol = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_be__");
        if (traceNamespaceSymbol != null) {
            for (TraceLabelSymbol label : trace.getSymbolManager().labels().getChildrenNamed(name, traceNamespaceSymbol)) {
                this.transferRegisterValueToLabel(registerValue, label, lazy.getBytesBigEndian());
            }
        }
        if ((nsRegMapLE = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_le__")) != null) {
            for (TraceLabelSymbol label : trace.getSymbolManager().labels().getChildrenNamed(name, nsRegMapLE)) {
                this.transferRegisterValueToLabel(registerValue, label, lazy.getBytesLittleEndian());
            }
        }
    }

    protected boolean isRegisterValue(TraceObjectValue objectValue) {
        TraceObject parent = objectValue.getParent();
        return parent != null && parent.getTargetSchema().getInterfaces().contains(TargetRegister.class) && "_value".equals(objectValue.getEntryKey());
    }

    public void onValueCreatedCheckTransfer(TraceObjectValue objectValue) {
        if (this.isRegisterValue(objectValue)) {
            try {
                this.onValueCreatedTransfer(objectValue);
            }
            catch (RegisterValueException e) {
                Msg.error((Object)((Object)this), (Object)e.getMessage());
            }
        }
    }

    public void onSymbolAddedCheckTransferToLabel(TraceLabelSymbol label, boolean isBigEndian) {
        TraceObjectManager objectManager = label.getTrace().getObjectManager();
        TargetObjectSchema schema = objectManager.getRootSchema();
        if (schema == null) {
            return;
        }
        PathMatcher matcher = schema.searchFor(TargetRegister.class, true);
        matcher = matcher.applyKeys(PathPredicates.Align.RIGHT, List.of(label.getName()));
        for (TraceObjectValPath traceObjectValPath : DBTraceObjectRegisterSupport.it(objectManager.getValuePaths(label.getLifespan(), (PathPredicates)matcher))) {
            Object regRaw = traceObjectValPath.getDestinationValue(objectManager.getRootObject());
            if (!(regRaw instanceof TraceObject)) continue;
            TraceObject regObj = (TraceObject)regRaw;
            this.transferRegisterObjectToLabel(regObj, label, isBigEndian);
        }
    }

    public void onSymbolAddedCheckTransfer(TraceSymbol symbol) {
        TraceObject root = symbol.getTrace().getObjectManager().getRootObject();
        if (root == null) {
            return;
        }
        if (symbol instanceof TraceLabelSymbol) {
            TraceLabelSymbol label = (TraceLabelSymbol)symbol;
            TraceNamespaceSymbolView namespaces = label.getTrace().getSymbolManager().namespaces();
            TraceNamespaceSymbol regMapBE = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_be__");
            TraceNamespaceSymbol regMapLE = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_le__");
            if (label.getParentNamespace() == regMapBE) {
                this.onSymbolAddedCheckTransferToLabel(label, true);
            } else if (label.getParentNamespace() == regMapLE) {
                this.onSymbolAddedCheckTransferToLabel(label, false);
            }
        }
    }

    public void onSpaceAddedCheckTransfer(Trace trace, AddressSpace space) {
        TraceObject root = trace.getObjectManager().getRootObject();
        if (root == null) {
            return;
        }
        assert (space.isOverlaySpace());
        if (!space.isRegisterSpace()) {
            return;
        }
        TraceMemorySpace mem = trace.getMemoryManager().getMemorySpace(space, true);
        TraceObject regContainer = trace.getObjectManager().getObjectByCanonicalPath(TraceObjectKeyPath.parse(mem.getAddressSpace().getName()));
        if (regContainer == null || !regContainer.getTargetSchema().getInterfaces().contains(TargetRegisterContainer.class)) {
            return;
        }
        TracePlatformManager platformManager = trace.getPlatformManager();
        this.onSpaceAddedCheckTransferToPlatformRegisters(platformManager.getHostPlatform(), regContainer, mem);
        for (TraceGuestPlatform platform : platformManager.getGuestPlatforms()) {
            this.onSpaceAddedCheckTransferToPlatformRegisters(platform, regContainer, mem);
        }
    }

    protected void onMappingAddedCheckTransferRegisterObjectMemoryMapped(TraceObject registerObject, TraceGuestPlatformMappedRange mapped) {
        String name = this.getRegisterName(registerObject);
        TraceGuestPlatform guest = mapped.getGuestPlatform();
        Register register = guest.getLanguage().getRegister(name);
        if (register == null || mapped.getGuestRange().contains(register.getAddress())) {
            return;
        }
        Address hostAddr = mapped.mapGuestToHost(register.getAddress());
        if (hostAddr == null) {
            return;
        }
        TraceMemorySpace mem = registerObject.getTrace().getMemoryManager().getMemorySpace(hostAddr.getAddressSpace(), true);
        for (TraceObjectValue traceObjectValue : DBTraceObjectRegisterSupport.it(registerObject.getOrderedValues(Lifespan.ALL, "_value", true))) {
            this.transferValueToPlatformRegister(traceObjectValue, guest, mem, register);
        }
    }

    public void onMappingAddedCheckTransferMemoryMapped(TraceObject root, TraceGuestPlatformMappedRange mapped) {
        for (TraceObjectValPath traceObjectValPath : DBTraceObjectRegisterSupport.it(root.querySuccessorsTargetInterface(Lifespan.ALL, TargetRegister.class, true))) {
            TraceObject registerObject = traceObjectValPath.getDestination(root);
            this.onMappingAddedCheckTransferRegisterObjectMemoryMapped(registerObject, mapped);
        }
    }

    public void onMappingAddedCheckTransfer(TraceGuestPlatformMappedRange mapped) {
        Trace trace = mapped.getHostPlatform().getTrace();
        TraceObject root = trace.getObjectManager().getRootObject();
        if (root == null) {
            return;
        }
        AddressSpace guestSpace = mapped.getGuestRange().getAddressSpace();
        if (guestSpace.isRegisterSpace()) {
            for (AddressSpace space : trace.getBaseAddressFactory().getAllAddressSpaces()) {
                if (!space.isOverlaySpace()) continue;
                this.onSpaceAddedCheckTransfer(trace, space);
            }
        } else if (guestSpace.isMemorySpace()) {
            if (guestSpace.isOverlaySpace()) {
                return;
            }
            this.onMappingAddedCheckTransferMemoryMapped(root, mapped);
        } else {
            throw new AssertionError();
        }
    }

    public void processEvent(TraceChangeRecord<?, ?> event) {
        HANDLER.handleTraceChangeRecord(event);
    }

    private void objectValueCreated(TraceObjectValue objectValue) {
        this.onValueCreatedCheckTransfer(objectValue);
    }

    private void symbolAdded(TraceSymbol symbol) {
        this.onSymbolAddedCheckTransfer(symbol);
    }

    private void spaceAdded(Trace trace, AddressSpace isNull, AddressSpace space) {
        this.onSpaceAddedCheckTransfer(trace, space);
    }

    private void guestMappingAdded(TraceGuestPlatform guest, TraceGuestPlatformMappedRange isNull, TraceGuestPlatformMappedRange mapped) {
        this.onMappingAddedCheckTransfer(mapped);
    }

    private static /* synthetic */ DBTraceObjectRegisterSupport[] $values() {
        return new DBTraceObjectRegisterSupport[]{INSTANCE};
    }

    static {
        $VALUES = DBTraceObjectRegisterSupport.$values();
        HANDLER = new TraceDomainObjectListener(){
            {
                this.listenFor(Trace.TraceObjectChangeType.VALUE_CREATED, INSTANCE::objectValueCreated);
                this.listenFor(Trace.TraceSymbolChangeType.ADDED, INSTANCE::symbolAdded);
                this.listenFor(Trace.TraceOverlaySpaceChangeType.ADDED, INSTANCE::spaceAdded);
                this.listenFor(Trace.TracePlatformChangeType.MAPPING_ADDED, INSTANCE::guestMappingAdded);
            }
        };
    }

    static class LazyValues {
        private final TraceObjectValue registerValue;
        private BigInteger value;
        private int bitLength = -1;
        private byte[] be;
        private byte[] le;

        public LazyValues(TraceObjectValue registerValue) {
            this.registerValue = registerValue;
        }

        BigInteger convertRegisterValueToBigInteger() throws RegisterValueException {
            Object val = this.registerValue.getValue();
            if (val instanceof String) {
                String s = (String)val;
                try {
                    return new BigInteger(s, 16);
                }
                catch (NumberFormatException e) {
                    throw new RegisterValueException("Invalid register value " + s + ". Must be hex digits only.");
                }
            }
            if (val instanceof byte[]) {
                byte[] arr = (byte[])val;
                return new BigInteger(1, arr);
            }
            if (val instanceof Byte) {
                Byte b = (Byte)val;
                return BigInteger.valueOf(b.byteValue());
            }
            if (val instanceof Short) {
                Short s = (Short)val;
                return BigInteger.valueOf(s.shortValue());
            }
            if (val instanceof Integer) {
                Integer i = (Integer)val;
                return BigInteger.valueOf(i.intValue());
            }
            if (val instanceof Long) {
                Long l = (Long)val;
                return BigInteger.valueOf(l);
            }
            if (val instanceof Address) {
                Address a = (Address)val;
                return a.getOffsetAsBigInteger();
            }
            throw new RegisterValueException("Cannot convert register value: (" + this.registerValue.getValue().getClass() + ") '" + this.registerValue.getValue() + "'");
        }

        int getRegisterValueBitLength() throws RegisterValueException {
            Object objBitLength = this.registerValue.getParent().getValue(this.registerValue.getMinSnap(), "_length").getValue();
            if (!(objBitLength instanceof Number)) {
                throw new RegisterValueException("Register length is not numeric: (" + objBitLength.getClass() + ") '" + objBitLength + "'");
            }
            return ((Number)objBitLength).intValue();
        }

        BigInteger getValue() throws RegisterValueException {
            if (this.value != null) {
                return this.value;
            }
            this.value = this.convertRegisterValueToBigInteger();
            return this.value;
        }

        int getBitLength() throws RegisterValueException {
            if (this.bitLength != -1) {
                return this.bitLength;
            }
            this.bitLength = this.getRegisterValueBitLength();
            return this.bitLength;
        }

        int getByteLength() throws RegisterValueException {
            return (this.getBitLength() + 7) / 8;
        }

        byte[] getBytesBigEndian() throws RegisterValueException {
            if (this.be != null) {
                return this.be;
            }
            this.be = Utils.bigIntegerToBytes((BigInteger)this.getValue(), (int)this.getByteLength(), (boolean)true);
            return this.be;
        }

        byte[] getBytesLittleEndian() throws RegisterValueException {
            if (this.le != null) {
                return this.le;
            }
            this.le = Utils.bigIntegerToBytes((BigInteger)this.getValue(), (int)this.getByteLength(), (boolean)false);
            return this.le;
        }

        public byte[] getBytes(boolean isBigEndian) throws RegisterValueException {
            return isBigEndian ? this.getBytesBigEndian() : this.getBytesLittleEndian();
        }
    }

    static class RegisterValueException
    extends Exception {
        public RegisterValueException(String message) {
            super(message);
        }
    }
}

