/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager;

import agent.frida.manager.FridaFunction;
import com.google.gson.JsonElement;
import java.util.Map;

public class FridaFrame {
    private String address;
    private int frameId;
    private FridaFunction function;

    public FridaFrame(Map<String, JsonElement> map, int n) {
        this.address = map.get("address").getAsString();
        this.frameId = n;
        this.function = new FridaFunction(map);
    }

    public int getFrameID() {
        return this.frameId;
    }

    public String getModuleName() {
        return this.function.getModuleName();
    }

    public String getFunctionName() {
        return this.function.getFunctionName();
    }

    public String getFileName() {
        return this.function.getFileName();
    }

    public long getLineNumber() {
        return this.function.getLineNumber();
    }

    public FridaFunction getFunction() {
        return this.function;
    }

    public String getAddress() {
        return this.address;
    }

    public Long getPC() {
        return Long.decode(this.address);
    }
}

