/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaSession;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;

public class FridaGetSessionAttributesCommand
extends AbstractFridaCommand<Void> {
    protected final FridaSession session;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public FridaGetSessionAttributesCommand(FridaManagerImpl manager, FridaSession session) {
        super(manager);
        this.session = session;
    }

    @Override
    public void invoke() {
        this.manager.setCurrentSession(this.session);
        this.manager.loadScript(this, "get_session_attributes", "var d = {};d['version'] = Frida.version;d['heapSize'] = Frida.heapSize;d['id'] = Process.id;d['arch'] = Process.arch;d['os'] = Process.platform;d['pageSize'] = Process.pageSize;d['pointerSize'] = Process.pointerSize;d['codeSigning'] = Process.codeSigningPolicy;d['debugger'] = Process.isDebuggerAttached();d['runtime'] = Script.runtime;d['kernel'] = Kernel.available;if (Kernel.available) {   d['kbase'] = Kernel.base;   d['kPageSize'] = Kernel.pageSize;}result = d;");
        this.session.setAttributes(this.attributes);
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        this.attributes = new HashMap<String, Object>();
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            this.attributes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }
}

