/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class FridaListModulesCommand
extends AbstractFridaCommand<Void> {
    protected final FridaProcess process;
    private List<FridaModule> modules = new ArrayList<FridaModule>();

    public FridaListModulesCommand(FridaManagerImpl manager, FridaProcess process) {
        super(manager);
        this.process = process;
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "list_modules", "result = Process.enumerateModules();");
        for (FridaModule module : this.modules) {
            this.manager.addModuleIfAbsent(this.process, module);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaModule module = new FridaModule(this.process);
        JsonObject modDetails = element.getAsJsonObject();
        module.setName(modDetails.get("name").getAsString());
        module.setPath(modDetails.get("path").getAsString());
        module.setRangeAddress(modDetails.get("base").getAsString());
        module.setRangeSize(modDetails.get("size").getAsLong());
        this.modules.add(module);
    }
}

