/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaSession;
import agent.frida.manager.cmd.FridaContinueCommand;
import agent.frida.model.iface2.FridaModelTargetModuleContainer;
import agent.frida.model.iface2.FridaModelTargetProcessContainer;
import agent.frida.model.iface2.FridaModelTargetSession;
import agent.frida.model.impl.FridaModelTargetKernelImpl;
import agent.frida.model.impl.FridaModelTargetModuleContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetProcessContainerImpl;
import agent.frida.model.impl.FridaModelTargetSessionAttributesImpl;
import agent.frida.model.impl.FridaModelTargetSessionContainerImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Session", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=FridaModelTargetSessionAttributesImpl.class, fixed=true), @TargetAttributeType(name="Processes", type=FridaModelTargetProcessContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Modules", type=FridaModelTargetModuleContainerImpl.class, required=true, fixed=true), @TargetAttributeType(type=Object.class)})
public class FridaModelTargetSessionImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetSession {
    protected static final String FRIDA_PROMPT = "(frida)";
    private Integer base = 10;
    protected final FridaModelTargetModuleContainer modules;
    protected final FridaModelTargetSessionAttributesImpl attrs = new FridaModelTargetSessionAttributesImpl(this);
    protected final FridaModelTargetProcessContainerImpl processes = new FridaModelTargetProcessContainerImpl(this);
    private FridaModelTargetUnloadScriptImpl unload;
    private FridaModelTargetKernelImpl kernel;
    protected String debugger = "frida";

    protected static String indexSession(FridaSession session) {
        return FridaClient.getId(session);
    }

    protected static String keySession(FridaSession session) {
        return PathUtils.makeKey((String)FridaModelTargetSessionImpl.indexSession(session));
    }

    public FridaModelTargetSessionImpl(FridaModelTargetSessionContainerImpl sessions, FridaSession session) {
        super(sessions.getModel(), (TargetObject)sessions, FridaModelTargetSessionImpl.keySession(session), session, "Session");
        this.modules = new FridaModelTargetModuleContainerImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, "");
        this.changeAttributes(List.of(), List.of(this.attrs, this.processes, this.modules), Map.of("_prompt", FRIDA_PROMPT, "_state", TargetExecutionStateful.TargetExecutionState.ALIVE, this.unload.getName(), this.unload), "Initialized");
        if (session.getAttribute("kernel").equals("true")) {
            this.kernel = new FridaModelTargetKernelImpl(this);
            this.changeAttributes(List.of(), List.of(this.kernel), Map.of(), "Initialized");
        }
        this.getManager().addEventsListener(this);
    }

    public String getDisplay() {
        FridaSession session = (FridaSession)this.getModelObject();
        Object pidstr = FridaClient.getId(session.getProcess());
        pidstr = this.base == 16 ? "0x" + (String)pidstr : Long.toString(Long.parseLong((String)pidstr, 16));
        return "[" + (String)pidstr + "]";
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public FridaModelTargetProcessContainer getProcesses() {
        return this.processes;
    }

    @Override
    public FridaModelTargetModuleContainer getModules() {
        return this.modules;
    }

    public FridaSession getSession() {
        return (FridaSession)this.getModelObject();
    }

    @Override
    public CompletableFuture<Void> resume() {
        return this.model.gateFuture(this.getManager().execute(new FridaContinueCommand(this.getManager())));
    }
}

