/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.pdb.pdbapplicator.ArrayTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class DefaultPdbUniversalMember
extends PdbMember {
    private MsTypeApplier applier;
    private DataType dataType;

    DefaultPdbUniversalMember(DefaultPdbApplicator applicator, String name, MsTypeApplier applier, int offset) {
        this(applicator, name, applier, offset, null);
        this.dataType = null;
    }

    DefaultPdbUniversalMember(DefaultPdbApplicator applicator, String name, MsTypeApplier applier, int offset, String memberComment) {
        super(name, applier.getDataType().getName(), offset, memberComment);
        this.applier = applier;
        this.dataType = null;
    }

    DefaultPdbUniversalMember(DefaultPdbApplicator applicator, String name, DataType dataType, int offset) {
        super(name, dataType.getName(), offset, null);
        this.applier = null;
        this.dataType = dataType;
    }

    MsTypeApplier getApplier() {
        return this.applier;
    }

    private DataType getDataTypeInternal() {
        if (this.applier != null) {
            return this.applier.getDataType();
        }
        return this.dataType;
    }

    @Override
    public String getDataTypeName() {
        return this.getDataTypeInternal().getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name=");
        builder.append(this.getName());
        DataType dt = this.getDataTypeInternal();
        if (dt instanceof PdbBitField) {
            PdbBitField bfDt = (PdbBitField)dt;
            builder.append(", type=");
            builder.append(bfDt.getBaseDataType().getName());
            builder.append(", offset=");
            builder.append(this.getOffset());
            builder.append(", bitSize=");
            builder.append(bfDt.getDeclaredBitSize());
            builder.append(", bitOffset=");
            builder.append(bfDt.getBitOffsetWithinBase());
        } else {
            builder.append(", type=");
            builder.append(dt.getName());
            builder.append(", offset=");
            builder.append(this.getOffset());
        }
        return builder.toString();
    }

    @Override
    protected WrappedDataType getDataType() throws CancelledException {
        DataType dt = this.getDataTypeInternal();
        if (this.applier != null && this.applier instanceof ArrayTypeApplier && BigInteger.ZERO.compareTo(this.applier.getSize()) == 0) {
            return new WrappedDataType(dt, true, false);
        }
        return new WrappedDataType(dt, false, false);
    }
}

