#!/bin/sh
#
# Author: Aaron Voisine <aaron@voisine.org>

#sudo port install gimp2 +without_gnome -dbus +quartz +atsui +no_x11 -x11

PREFIX="/usr/local"

FOO="`pwd`/GIMP.app/Contents/Resources/"

BIN=`echo $PREFIX/bin/gimp*-2.? $PREFIX/lib/gimp/2.0/plug-ins/* $PREFIX/bin/python2.?`

SO=`echo $PREFIX/lib/gimp/2.0/*/*.so $PREFIX/lib/gtk-2.0/*/*/*.so $PREFIX/lib/pango/*/*/*.so`

LIB=`otool -L $BIN $SO | grep -v : | grep $PREFIX/ | awk '{print $1;}' | sed -E 's/([0-9][.])dylib/\1*dylib/g' | sort -u | xargs echo`

ETC="$PREFIX/etc/gimp/ $PREFIX/etc/gtk-2.0/ $PREFIX/etc/pango/ $PREFIX/lib/gimp/2.0/python/*.py* $PREFIX/lib/gimp/2.0/environ $PREFIX/lib/gimp/2.0/interpreters $PREFIX/etc/fonts"

SHARE=`echo $PREFIX/share/gimp/ $PREFIX/share/locale/*/LC_MESSAGES/gimp*`

cp ScriptExecCocoa/build/Release/ScriptExec.app/Contents/MacOS/ScriptExec $FOO/../MacOS/GIMP

cd $PREFIX

echo $BIN $SO $LIB $ETC $SHARE | sed "s|$PREFIX/"'*||g' | xargs tar -cf /tmp/gimpguts.tar

cd $FOO

tar -xf /tmp/gimpguts.tar
rm /tmp/gimpguts.tar

cat $PREFIX/etc/gimp/2.0/gimprc | sed 's/web-browser [^)]*/&)\
(web-browser "open %s"/' | sed 's/help-browser[^)]*/&)\
(help-browser web-browser/' | sed 's/temp-path[^)]*/&)\
(temp-path "${ETC}"/' | sed 's/swap-path[^)]*/&)\
(swap-path "${ETC}"/' | sed 's/num-processors[^)]*/&)\
(num-processors 2/' | sed 's|interpreter-path[^)]*|&\
(interpreter-path "${ETC}/interp"|' > $FOO/etc/gimp/2.0/gimprc

cat $PREFIX/etc/gtk-2.0/gtk.immodules | sed 's|'"$PREFIX"'/*|${CWD}/|g' > $FOO/etc/gtk-2.0/gtk.immodules
cat $PREFIX/etc/gtk-2.0/gdk-pixbuf.loaders | sed 's|'"$PREFIX"'/*|${CWD}/|g' > $FOO/etc/gtk-2.0/gdk-pixbug.loaders
cat $PREFIX/etc/pango/pangorc | sed 's|'"$PREFIX"'/*etc/pango|${ETC}|g' > $FOO/etc/pango/pangorc
cat $PREFIX/etc/pango/pango.modules | sed 's|'"$PREFIX"'[^ ]*|"&"|g' | sed 's|'"$PREFIX"'/*|${CWD}/|g' > $FOO/etc/pango/pango.modules
cat $PREFIX/lib/gimp/2.0/interpreters/pygimp.interp | sed 's|'"$PREFIX"'/*bin/|${ETC}/|g' > $FOO/lib/gimp/2.0/interpreters/pygimp.interp

cat $PREFIX/share/gimp/2.0/themes/Default/gtkrc | sed 's/GimpUnitComboBox::appears_as_list = 0/&\
\
  font_name = "sans 12"/' | sed 's/sans 8/sans 11/' > $FOO/share/gimp/2.0/themes/Default/gtkrc
cat $PREFIX/share/gimp/2.0/themes/Small/gtkrc | sed 's/# font_name = "sans 8"/  font_name = "sans 11"/' > $FOO/share/gimp/2.0/themes/Small/gtkrc

# hack to fix keyboard shortcuts intercepting text input
MENURC="$FOO/etc/gimp/2.0/menurc"
echo '(gtk_accel_path "<Actions>/tools/tools-clone" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-ellipse-select" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/view/view-zoom-in" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/view/view-zoom-out" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-value-1-decrease" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-value-2-decrease" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/quick-mask/quick-mask-toggle" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/context/context-swatch-foreground-previous" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-text" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/context/context-colors-swap" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-vector" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-paintbrush" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-scale" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/context/context-colors-default" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-airbrush" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/view/view-zoom-1-1" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/view/view-zoom-in-accel" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-heal" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-blend" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-eraser" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-free-select" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/view/view-zoom-revert" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-value-1-increase" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-value-2-increase" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-by-color-select" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-bucket-fill" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-convolve" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/vectors/vectors-selection-from-vectors" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-move" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-measure" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-shear" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-crop" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-zoom" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-iscissors" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-pencil" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-rotate" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/context/context-swatch-foreground-next" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-dodge-burn" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-rect-select" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-flip" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-ink" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-perspective" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-align" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-smudge" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-value-2-decrease-skip" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-value-2-increase-skip" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-fuzzy-select" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/view/view-zoom-out-accel" "")' >> $MENURC
echo '(gtk_accel_path "<Actions>/tools/tools-color-picker" "")' >> $MENURC
