/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class VertexAttributes
implements Iterable<VertexAttribute>,
Comparable<VertexAttributes> {
    private final VertexAttribute[] attributes;
    public final int vertexSize;
    private long mask = -1L;
    private ReadonlyIterable<VertexAttribute> iterable;

    public VertexAttributes(VertexAttribute ... attributes) {
        if (attributes.length == 0) {
            throw new IllegalArgumentException("attributes must be >= 1");
        }
        VertexAttribute[] list = new VertexAttribute[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            list[i] = attributes[i];
            ++i;
        }
        this.attributes = list;
        this.vertexSize = this.calculateOffsets();
    }

    public int getOffset(int usage, int defaultIfNotFound) {
        VertexAttribute vertexAttribute = this.findByUsage(usage);
        if (vertexAttribute == null) {
            return defaultIfNotFound;
        }
        return vertexAttribute.offset / 4;
    }

    public int getOffset(int usage) {
        return this.getOffset(usage, 0);
    }

    public VertexAttribute findByUsage(int usage) {
        int len = this.size();
        int i = 0;
        while (i < len) {
            if (this.get((int)i).usage == usage) {
                return this.get(i);
            }
            ++i;
        }
        return null;
    }

    private int calculateOffsets() {
        int count = 0;
        int i = 0;
        while (i < this.attributes.length) {
            VertexAttribute attribute = this.attributes[i];
            attribute.offset = count;
            count += attribute.getSizeInBytes();
            ++i;
        }
        return count;
    }

    public int size() {
        return this.attributes.length;
    }

    public VertexAttribute get(int index) {
        return this.attributes[index];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int i = 0;
        while (i < this.attributes.length) {
            builder.append("(");
            builder.append(this.attributes[i].alias);
            builder.append(", ");
            builder.append(this.attributes[i].usage);
            builder.append(", ");
            builder.append(this.attributes[i].numComponents);
            builder.append(", ");
            builder.append(this.attributes[i].offset);
            builder.append(")");
            builder.append("\n");
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VertexAttributes)) {
            return false;
        }
        VertexAttributes other = (VertexAttributes)obj;
        if (this.attributes.length != other.attributes.length) {
            return false;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (!this.attributes[i].equals(other.attributes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        long result = 61 * this.attributes.length;
        int i = 0;
        while (i < this.attributes.length) {
            result = result * 61L + (long)this.attributes[i].hashCode();
            ++i;
        }
        return (int)(result ^ result >> 32);
    }

    public long getMask() {
        if (this.mask == -1L) {
            long result = 0L;
            int i = 0;
            while (i < this.attributes.length) {
                result |= (long)this.attributes[i].usage;
                ++i;
            }
            this.mask = result;
        }
        return this.mask;
    }

    public long getMaskWithSizePacked() {
        return this.getMask() | (long)this.attributes.length << 32;
    }

    @Override
    public int compareTo(VertexAttributes o) {
        long m2;
        if (this.attributes.length != o.attributes.length) {
            return this.attributes.length - o.attributes.length;
        }
        long m1 = this.getMask();
        if (m1 != (m2 = o.getMask())) {
            return m1 < m2 ? -1 : 1;
        }
        int i = this.attributes.length - 1;
        while (i >= 0) {
            VertexAttribute va0 = this.attributes[i];
            VertexAttribute va1 = o.attributes[i];
            if (va0.usage != va1.usage) {
                return va0.usage - va1.usage;
            }
            if (va0.unit != va1.unit) {
                return va0.unit - va1.unit;
            }
            if (va0.numComponents != va1.numComponents) {
                return va0.numComponents - va1.numComponents;
            }
            if (va0.normalized != va1.normalized) {
                return va0.normalized ? 1 : -1;
            }
            if (va0.type != va1.type) {
                return va0.type - va1.type;
            }
            --i;
        }
        return 0;
    }

    @Override
    public Iterator<VertexAttribute> iterator() {
        if (this.iterable == null) {
            this.iterable = new ReadonlyIterable<VertexAttribute>(this.attributes);
        }
        return this.iterable.iterator();
    }

    private static class ReadonlyIterable<T>
    implements Iterable<T> {
        private final T[] array;
        private ReadonlyIterator iterator1;
        private ReadonlyIterator iterator2;

        public ReadonlyIterable(T[] array) {
            this.array = array;
        }

        @Override
        public Iterator<T> iterator() {
            if (Collections.allocateIterators) {
                return new ReadonlyIterator<T>(this.array);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new ReadonlyIterator<T>(this.array);
                this.iterator2 = new ReadonlyIterator<T>(this.array);
            }
            if (!this.iterator1.valid) {
                this.iterator1.index = 0;
                this.iterator1.valid = true;
                this.iterator2.valid = false;
                return this.iterator1;
            }
            this.iterator2.index = 0;
            this.iterator2.valid = true;
            this.iterator1.valid = false;
            return this.iterator2;
        }
    }

    private static class ReadonlyIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final T[] array;
        int index;
        boolean valid = true;

        public ReadonlyIterator(T[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.array.length;
        }

        @Override
        public T next() {
            if (this.index >= this.array.length) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.array[this.index++];
        }

        @Override
        public void remove() {
            throw new GdxRuntimeException("Remove not allowed.");
        }

        public void reset() {
            this.index = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    public static final class Usage {
        public static final int Position = 1;
        public static final int ColorUnpacked = 2;
        public static final int ColorPacked = 4;
        public static final int Normal = 8;
        public static final int TextureCoordinates = 16;
        public static final int Generic = 32;
        public static final int BoneWeight = 64;
        public static final int Tangent = 128;
        public static final int BiNormal = 256;
    }
}

