/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Bezier;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BezierTest {
    private static float epsilon = Float.MIN_NORMAL;
    private static float epsilonApprimations = 1.0E-6f;
    @Parameterized.Parameter(value=0)
    public ImportType type;
    @Parameterized.Parameter(value=1)
    public boolean useSetter;
    private Bezier<Vector2> bezier;

    @Parameterized.Parameters(name="imported type {0} use setter {1}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        ImportType[] importTypeArray = ImportType.values();
        int n = importTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportType type = importTypeArray[n2];
            parameters.add(new Object[]{type, true});
            parameters.add(new Object[]{type, false});
            ++n2;
        }
        return parameters;
    }

    @Before
    public void setup() {
        this.bezier = null;
    }

    protected Vector2[] create(Vector2[] points) {
        if (this.useSetter) {
            this.bezier = new Bezier();
            if (this.type == ImportType.LibGDXArrays) {
                this.bezier.set(new Array<Vector2>(points), 0, points.length);
            } else if (this.type == ImportType.JavaArrays) {
                this.bezier.set(points, 0, points.length);
            } else {
                this.bezier.set(points);
            }
        } else {
            this.bezier = this.type == ImportType.LibGDXArrays ? new Bezier<Vector2>(new Array<Vector2>(points), 0, points.length) : (this.type == ImportType.JavaArrays ? new Bezier((Vector[])points, 0, points.length) : new Bezier((Vector[])points));
        }
        return points;
    }

    @Test
    public void testLinear2D() {
        Vector2[] points = this.create(new Vector2[]{new Vector2(0.0f, 0.0f), new Vector2(1.0f, 1.0f)});
        float len = this.bezier.approxLength(2);
        Assert.assertEquals((double)Math.sqrt(2.0), (double)len, (double)epsilonApprimations);
        Vector2 d = this.bezier.derivativeAt(new Vector2(), 0.5f);
        Assert.assertEquals((float)1.0f, (float)d.x, (float)epsilon);
        Assert.assertEquals((float)1.0f, (float)d.y, (float)epsilon);
        Vector2 v = this.bezier.valueAt(new Vector2(), 0.5f);
        Assert.assertEquals((float)0.5f, (float)v.x, (float)epsilon);
        Assert.assertEquals((float)0.5f, (float)v.y, (float)epsilon);
        float t = this.bezier.approximate(new Vector2(0.5f, 0.5f));
        Assert.assertEquals((float)0.5f, (float)t, (float)epsilonApprimations);
        float l = this.bezier.locate(new Vector2(0.5f, 0.5f));
        Assert.assertEquals((float)0.5f, (float)t, (float)epsilon);
    }

    private static enum ImportType {
        LibGDXArrays,
        JavaArrays,
        JavaVarArgs;

    }
}

