/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterBoxMenu;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.PlayerRow;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Monster;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.util.Animator;
import com.esotericsoftware.gloomhavenhelper.util.HPAdjust;
import com.esotericsoftware.gloomhavenhelper.util.Row;

public class MonsterBox
extends Actor
implements Comparable,
Animator.HasAnimator {
    private static final float conditionSpacing = 26.0f;
    public final Row row;
    public final Monster monster;
    private final float scale;
    private float hpPercent;
    private float conditionsRight;
    private float conditionsRightTarget;
    public final Animator animator = new Animator(this, 10.0f, 500.0f, 150.0f);
    long lastAnimateIcon;
    HPAdjust hpAdjust;
    private Drawable bgDrawable;
    private Drawable summonXDrawable;
    private TextureRegion hpRegion;
    private NinePatch conditionsPatch;
    MonsterBoxMenu menu;

    public MonsterBox(Row row, Monster monster, float scale) {
        this.row = row;
        this.monster = monster;
        this.scale = scale;
        this.hpPercent = Math.min(1.0f, (float)monster.hp / (float)monster.hpMax);
        this.create();
        this.layoutUI();
        this.events();
    }

    private void create() {
        this.bgDrawable = App.skin.getDrawable("psd/monster-" + (Object)((Object)this.monster.type));
        this.summonXDrawable = App.skin.getDrawable("summon/x");
        this.hpRegion = App.skin.getRegion("psd/monster-hp");
        this.conditionsPatch = App.skin.getPatch("psd/conditions");
        this.menu = new MonsterBoxMenu(this);
        this.hpAdjust = new HPAdjust((Actor)this, "plainExtraLargeNumbers"){

            @Override
            protected void getPosition(Vector2 position) {
                MonsterBox.this.localToStageCoordinates(position.set(104.0f, 11.0f));
            }

            @Override
            protected int getMax() {
                return MonsterBox.this.monster.hpMax;
            }

            @Override
            protected int getValue() {
                return MonsterBox.this.monster.hp;
            }

            @Override
            protected void setValue(int value) {
                if (MonsterBox.this.monster.hp != value) {
                    MonsterBox.this.hpChanged(value + this.extra - this.start);
                }
                MonsterBox.this.monster.hp = value;
                if (value > 0) {
                    App.state.changed();
                }
                super.setValue(value);
            }

            @Override
            protected void apply() {
                MonsterBox.this.checkDead(false);
            }
        };
    }

    private void layoutUI() {
        if (this.monster.data.isBoss()) {
            this.setHeight(95.0f * this.scale + 4.0f);
        } else {
            this.setHeight(90.0f * this.scale + 4.0f);
        }
        this.conditionsRight = this.conditionsRightTarget = 117.0f + 26.0f * (float)((this.monster.conditions.size - 1) / 2);
        if (this.monster.conditions.size == 0) {
            this.conditionsRight -= 40.0f;
        }
        this.setWidth(this.conditionsRight + 5.0f + 26.0f * this.scale);
    }

    private void events() {
        this.addListener(new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.stop();
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MonsterBox.this.showMenu();
            }
        });
    }

    public void showMenu() {
        this.localToAscendantCoordinates(App.gloom.rows, App.v2.set(0.0f, 0.0f));
        App.gloom.rowsScroll.scrollTo(0.0f, App.v2.y - 7.0f, 0.0f, this.getHeight() + 14.0f);
        this.menu.show(this, 3.0f, -15.0f, -3.0f, 0.0f, true);
        this.hpAdjust.changeContainer.clearActions();
        this.hpAdjust.changeContainer.setVisible(false);
    }

    @Override
    protected void sizeChanged() {
        Group parent = this.getParent();
        if (parent instanceof Layout) {
            ((Layout)((Object)parent)).invalidate();
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        float width = this.conditionsRight + 5.0f + 26.0f;
        if (width != this.getWidth()) {
            this.setWidth(width);
            this.row.monstersGroup.invalidateHierarchy();
            Animator.storeChildren(this.row.monstersGroup, 0.0f);
        }
        this.hpPercent = App.animate(this.hpPercent, Math.min(1.0f, (float)this.monster.hp / (float)this.monster.hpMax), 0.2f, 2.0f, 2.0f, delta);
        this.conditionsRightTarget = 117.0f + 26.0f * (float)((this.monster.conditions.size - 1) / 2);
        if (this.monster.conditions.size == 0) {
            this.conditionsRightTarget -= 40.0f;
        }
        this.conditionsRight = App.animate(this.conditionsRight, this.conditionsRightTarget, 20.0f, 200.0f, 25.0f, delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        boolean desat;
        this.animator.update();
        boolean bl = desat = this.monster.hp <= 0 || this.getParent() == App.stage.getRoot();
        if (desat) {
            batch.setShader(App.desatShader);
            App.desatShader.setUniformf("u_desat", 1.0f);
        }
        float boxX = this.getX();
        float boxY = this.getY();
        float a = this.getColor().a * parentAlpha;
        boxY = this.monster.type != MonsterType.summon ? (boxY -= 4.0f) : (boxY += 7.0f);
        batch.setColor(1.0f, 1.0f, 1.0f, a);
        int conditionsMinus1 = this.monster.conditions.size - 1;
        float conditionsX = 0.0f;
        if (this.conditionsRight > 77.0f) {
            conditionsX = this.conditionsRight - 26.0f * (float)(conditionsMinus1 / 2);
            float w = 67.0f + 26.0f * (float)(conditionsMinus1 / 2);
            float offset = this.conditionsRightTarget - this.conditionsRight;
            batch.setColor(1.0f, 1.0f, 1.0f, a);
            this.conditionsPatch.setColor(App.c(1.0f, 1.0f, 1.0f, a));
            this.conditionsPatch.draw(batch, boxX + conditionsX - 47.0f + offset, boxY + 10.0f, w -= offset, 65.0f);
        }
        this.bgDrawable.draw(batch, boxX, boxY, this.bgDrawable.getMinWidth(), this.bgDrawable.getMinHeight());
        if (this.monster.type == MonsterType.summon) {
            this.monster.summonColor.drawable.draw(batch, boxX + 38.0f, boxY + 56.0f, 36.0f, 36.0f);
            if (this.monster.isNew) {
                this.summonXDrawable.draw(batch, boxX + 38.0f, boxY + 56.0f, 36.0f, 36.0f);
            }
        }
        int hp = this.monster.hp;
        if (this.hpPercent > 0.0f) {
            int hpMax = this.monster.hpMax;
            batch.setColor(App.c(hp <= 3 && this.hpPercent <= 0.4f && hp != hpMax || this.hpPercent < 0.3f ? App.healthRed : App.healthGreen, a));
            float deadFade = MathUtils.clamp(this.hpPercent / (1.0f / (float)hpMax), 0.0f, 1.0f);
            this.hpRegion.setRegionWidth((int)Math.max(8.0f * deadFade, (float)Math.round(98.0f * this.hpPercent)));
            batch.draw(this.hpRegion, boxX + 8.0f, boxY + 10.0f);
        }
        if (this.monster.type == MonsterType.boss) {
            App.fancyExtraLargeOutlineNumbers.setColor(App.c(App.bossRed, a));
        } else if (this.monster.type == MonsterType.elite) {
            App.fancyExtraLargeOutlineNumbers.setColor(App.c(App.eliteGold, a));
        } else {
            App.fancyExtraLargeOutlineNumbers.setColor(1.0f, 1.0f, 1.0f, a);
        }
        float x = boxX + 20.0f;
        float y = boxY + 68.0f;
        int number = this.monster.number;
        if (number == 1) {
            x += 5.0f;
            y -= 1.0f;
        } else if (number == 2) {
            x += 1.0f;
        } else if (number == 7) {
            x += 2.0f;
        } else if (number >= 10) {
            x = number == 11 ? (x -= 1.0f) : (x -= 5.0f);
            if (App.config.isRussian()) {
                x -= 4.0f;
            }
            y -= 1.0f;
        }
        String string = Integer.toString(number);
        if (number >= 10 && App.config.isRussian()) {
            GlyphLayout layout = new GlyphLayout();
            layout.setText(App.fancyExtraLargeOutlineNumbers, string, 0, string.length(), App.fancyExtraLargeOutlineNumbers.getColor(), 0.0f, 8, false, null);
            layout.runs.first().xAdvances.incr(1, -5.0f);
            App.fancyExtraLargeOutlineNumbers.draw(batch, layout, x, y);
        } else {
            App.fancyExtraLargeOutlineNumbers.draw(batch, Integer.toString(number), x, y);
        }
        BitmapFont font = App.plainExtraLargeNumbers;
        float x2 = boxX + 58.0f;
        float y2 = boxY + 63.0f;
        if (App.config.isJapanese()) {
            x2 += 4.0f;
            y2 -= 5.0f;
        }
        if (hp == 2 || hp == 3) {
            x2 += 1.0f;
        }
        if (hp >= 100) {
            font = App.plainLargeFixedNumbers;
            x2 += 2.0f;
            y2 -= 15.0f;
            if (hp >= 200) {
                x2 += 1.0f;
            }
            if (App.config.isRussian()) {
                x2 -= 2.0f;
            }
            if (App.config.isJapanese()) {
                x2 -= 7.0f;
            }
        } else if (hp >= 20) {
            x2 += 1.0f;
            if (App.config.isRussian()) {
                x2 += 2.0f;
            }
        } else if (hp >= 10) {
            if (App.config.isRussian()) {
                x2 += 5.0f;
            }
        } else {
            x2 += 12.0f;
            if (hp == 1 || hp == 3) {
                x2 -= 1.0f;
            } else if (hp == 8 || hp == 9) {
                x2 += 1.0f;
            }
            if (App.config.isRussian()) {
                x2 += 3.0f;
            }
        }
        font.setColor(1.0f, 1.0f, 1.0f, a);
        font.draw(batch, String.valueOf(hp), x2, y2);
        float y3 = boxY + 25.0f;
        int i = 0;
        while (i <= conditionsMinus1) {
            Condition condition = this.monster.conditions.get(conditionsMinus1 - i);
            float cy = y3;
            if (i != conditionsMinus1 || i % 2 != 0) {
                cy += (float)(i % 2 == 0 ? 19 : -19);
            }
            float cx = conditionsX + 26.0f * (float)(i / 2);
            batch.setColor(1.0f, 1.0f, 1.0f, a * Interpolation.slowFast.apply(Math.min(1.0f, (cx - 75.0f) / 42.0f)));
            condition.drawable.draw(batch, boxX + cx, cy, condition.drawable.getMinWidth(), condition.drawable.getMinHeight());
            ++i;
        }
        if (desat) {
            batch.setShader(null);
        }
    }

    public int compareTo(Object other) {
        int diff;
        if (!(other instanceof MonsterBox)) {
            return 0;
        }
        if (this.row instanceof PlayerRow) {
            return 0;
        }
        MonsterBox box = (MonsterBox)other;
        if (App.state.elitesFirst && (diff = (this.monster.type == MonsterType.elite ? 0 : 1) - (box.monster.type == MonsterType.elite ? 0 : 1)) != 0) {
            return diff;
        }
        diff = this.monster.summonColor.ordinal() - box.monster.summonColor.ordinal();
        if (diff != 0) {
            return diff;
        }
        return this.monster.number - box.monster.number;
    }

    @Override
    protected void setParent(Group parent) {
        super.setParent(parent);
        if (parent == null) {
            this.hpAdjust.changeContainer.remove();
        } else {
            App.stage.addActor(this.hpAdjust.changeContainer);
        }
    }

    @Override
    public Animator getAnimator() {
        return this.animator;
    }

    public void checkDead(boolean delay) {
        if (this.monster.hp > 0) {
            return;
        }
        this.removeMonster(delay);
        App.state.changed();
    }

    public void removeMonster(boolean delay) {
        if (this.getParent() == null) {
            return;
        }
        if (this.getParent().getParent() == null) {
            return;
        }
        this.animator.animating = false;
        Animator.enabled = false;
        final float startHeight = this.row.getPrefHeight();
        this.localToStageCoordinates(App.v2.set(0.0f, 0.0f));
        this.row.boxes.removeValue(this, true);
        App.stage.addActor(this);
        this.setPosition(App.v2.x, App.v2.y);
        final float endHeight = this.row.getPrefHeight();
        Animator.enabled = true;
        if (startHeight != endHeight) {
            this.row.animateHeight = startHeight;
            App.gloom.rows.addAction(Actions.sequence((Action)new TemporalAction(0.5f){

                @Override
                protected void update(float percent) {
                    MonsterBox.this.row.animateHeight = Interpolation.fastSlow.apply(startHeight, endHeight, percent);
                    MonsterBox.this.row.invalidateHierarchy();
                }

                @Override
                protected void end() {
                    MonsterBox.this.row.animateHeight = 0.0f;
                    MonsterBox.this.row.invalidateHierarchy();
                }
            }));
        }
        Animator.storeChildren(this.row.monstersGroup, 0.0f);
        this.row.monstersGroup.invalidateHierarchy();
        App.root.validate();
        this.setTouchable(Touchable.disabled);
        this.addAction(Actions.sequence((Action)Actions.delay(delay ? 0.2f : 0.0f), (Action)Actions.parallel((Action)Actions.fadeOut(1.1f, Interpolation.slowFast), (Action)Actions.moveTo(this.getX(), this.getY() - 60.0f, 1.5f, Interpolation.fastSlow)), (Action)Actions.removeActor()));
    }

    void hpChanged(int amount) {
        long time = System.currentTimeMillis();
        if (time < this.lastAnimateIcon + 1000L) {
            return;
        }
        this.lastAnimateIcon = time;
        Array<String> names = new Array<String>(2);
        if (this.monster.conditions.contains(Condition.poison, true)) {
            names.add("poison");
        }
        if (amount < 0) {
            if (this.row instanceof MonsterRow && ((MonsterRow)this.row).abilityCard.statValue("shield", this.monster.type, 0) > 0) {
                names.add("shield");
            }
        } else if (amount > 0 && this.monster.conditions.contains(Condition.wound, true)) {
            names.add("wound");
        }
        this.flashIcons(names);
    }

    public void flashIcons(Array<String> names) {
        int i = 0;
        int n = names.size;
        while (i < n) {
            final String name = names.get(i);
            if (i > 0) {
                this.row.addAction(Actions.sequence((Action)Actions.delay((float)i * 0.4f), new Action(){

                    @Override
                    public boolean act(float delta) {
                        MonsterBox.this.flashIcon(name);
                        return true;
                    }
                }));
            } else {
                this.flashIcon(name);
            }
            ++i;
        }
    }

    public void flashIcon(String name) {
        this.row.animateIcon(this, "conditions/" + name + "-large", name.equals("shield") ? 1.3f : 1.6f, 54.0f, 40.0f);
    }

    @Override
    public String toString() {
        return String.valueOf(this.monster.data.name) + " #" + this.monster.number + ", " + (Object)((Object)this.monster.summonColor) + " " + this.monster.summonColor.ordinal();
    }
}

