/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.network;

import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.network.GameClient;
import com.esotericsoftware.gloomhavenhelper.network.GameServer;
import com.esotericsoftware.gloomhavenhelper.network.Message;
import com.esotericsoftware.gloomhavenhelper.util.Input;
import com.esotericsoftware.gloomhavenhelper.util.Output;
import com.esotericsoftware.tcpserver.BroadcastClient;
import com.esotericsoftware.tcpserver.BroadcastServer;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class Network {
    static final GameServer gameServer = new GameServer();
    static final GameClient gameClient = new GameClient();
    static final BroadcastServer broadcastServer = new BroadcastServer("broadcast", "BroadcastServer", 58887){
        private final byte[] response = new byte[BroadcastServer.prefix.length + 4];
        {
            this.setDaemon(true);
            System.arraycopy(BroadcastServer.prefix, 0, this.response, 0, BroadcastServer.prefix.length);
        }

        @Override
        protected byte[] responseBuffer(DatagramPacket packet) {
            Output.writeInt(this.response, BroadcastServer.prefix.length, App.config.serverPort);
            return this.response;
        }
    };
    static final BroadcastClient broadcastClient = new BroadcastClient("broadcast", "BroadcastClient", 58887){
        private final byte[] buffer = new byte[BroadcastServer.prefix.length + 4];
        {
            this.setDaemon(true);
            this.setRetryDelays(3);
        }

        @Override
        protected void retry() {
            App.sleep(3000);
            if (!this.running) {
                return;
            }
            if (App.config.server) {
                return;
            }
            if (!App.config.client) {
                return;
            }
            if (gameClient.isConnected()) {
                return;
            }
            super.retry();
        }

        @Override
        protected byte[] receiveBuffer() {
            return this.buffer;
        }

        @Override
        protected void received(DatagramPacket packet) {
            try {
                if (App.config.server) {
                    return;
                }
                if (!App.config.client) {
                    return;
                }
                if (gameClient.isConnected()) {
                    return;
                }
                App.config.clientHost = packet.getAddress().getHostAddress();
                int port = Input.readInt(packet.getData(), BroadcastServer.prefix.length);
                if (port > 0) {
                    App.config.clientPort = port;
                }
                gameClient.update();
                App.sleep(3000);
            }
            finally {
                this.stop();
            }
        }
    };

    public static void update() {
        gameClient.update();
        gameServer.update();
    }

    public static void send(Message message, byte[] bytes, int offset, int count) {
        if (App.config.server) {
            gameServer.send(message.value, bytes, 0, count);
        } else {
            gameClient.send(message.value, bytes, 0, count);
        }
    }

    public static boolean clientRunning() {
        return gameClient.isRunning();
    }

    public static boolean clientIsConnected() {
        return gameClient.getConnection() != null;
    }

    public static boolean serverRunning() {
        return gameServer.isRunning();
    }

    public static boolean serverHasClient() {
        return gameServer.isRunning() && gameServer.getConnections().size() > 0;
    }

    public static String getHost() {
        return gameClient.getHost();
    }

    public static String getIPs() {
        StringBuilder buffer = new StringBuilder();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    buffer.append(address.getHostAddress());
                    buffer.append('\n');
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static void loadState(byte[] bytes) {
        block6: {
            try {
                int position = App.game.loadState(bytes, true);
                int remaining = bytes[position] & 0xFF;
                if (remaining <= 0) break block6;
                int i = bytes.length - remaining;
                switch (bytes[i]) {
                    case 97: {
                        App.animateAttackCard(App.readAttackModifier(bytes[i + 1]), App.readAttackModifier(bytes[i + 2]), App.readAttackModifier(bytes[i + 3]));
                        break;
                    }
                    case 98: {
                        App.setAttackCards(App.readAttackModifier(bytes[i + 1]), App.readAttackModifier(bytes[i + 2]));
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to read game state.", ex);
            }
        }
    }

    public static byte[] combine(Output output, byte[] animate, int offset) {
        int count = output.position();
        byte[] copy = new byte[animate != null ? count + 1 + animate.length - offset : count + 1];
        System.arraycopy(output.getBuffer(), 0, copy, 0, count);
        if (animate != null) {
            copy[count] = (byte)(animate.length - offset);
            if (animate.length - offset > 255) {
                throw new RuntimeException();
            }
            System.arraycopy(animate, offset, copy, count + 1, animate.length - offset);
        }
        return copy;
    }
}

