/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.gloomhavenhelper.App;

public class Animator {
    public static boolean enabled = true;
    private Actor actor;
    public final Vector2 target = new Vector2();
    public float delay;
    public boolean animating;
    float minSpeed;
    float maxSpeed;
    float distanceForMaxSpeed;

    public Animator(Actor actor, float minSpeed, float maxSpeed, float distanceForMaxSpeed) {
        this.actor = actor;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.distanceForMaxSpeed = distanceForMaxSpeed;
    }

    public void store(float delay) {
        this.delay = Math.max(delay, this.delay);
        this.target.set(this.actor.getX(), this.actor.getY());
        this.animating = true;
    }

    public void update() {
        if (!enabled) {
            return;
        }
        if (!this.animating) {
            return;
        }
        float delta = Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f);
        float x = this.actor.getX();
        float y = this.actor.getY();
        if (x == this.target.x && y == this.target.y) {
            this.finish(true);
        } else {
            this.delay -= delta;
            if (this.delay <= 0.0f) {
                App.animate(App.v2.set(x, y), this.target, this.minSpeed, this.maxSpeed, this.distanceForMaxSpeed, delta);
                this.actor.setPosition(App.v2.x, App.v2.y);
            }
        }
        Gdx.graphics.requestRendering();
    }

    public void finish(boolean invalidate) {
        this.animating = false;
        this.delay = 0.0f;
        this.actor.setPosition(this.target.x, this.target.y);
        if (invalidate && !Animator.childrenAnimating(this.actor.getParent())) {
            ((WidgetGroup)this.actor.getParent()).invalidate();
        }
    }

    public static void updateChildren(WidgetGroup parent) {
        SnapshotArray<Actor> children = parent.getChildren();
        int i = 0;
        int n = children.size;
        while (i < n) {
            Actor child = (Actor)children.get(i);
            if (child instanceof HasAnimator) {
                Animator animator = ((HasAnimator)((Object)child)).getAnimator();
                animator.update();
            }
            ++i;
        }
    }

    public static void storeChildren(WidgetGroup parent, float delay) {
        SnapshotArray<Actor> children = parent.getChildren();
        int n = children.size;
        FloatArray before = new FloatArray(n * 2);
        int i = 0;
        while (i < n) {
            Actor child = (Actor)children.get(i);
            if (child instanceof HasAnimator) {
                before.add(child.getX());
                before.add(child.getY());
            }
            ++i;
        }
        enabled = false;
        float oldWidth = parent.getWidth();
        float oldHeight = parent.getHeight();
        parent.invalidateHierarchy();
        App.root.validate();
        int i2 = 0;
        int b = 0;
        while (i2 < n) {
            Actor child = (Actor)children.get(i2);
            if (child instanceof HasAnimator) {
                Animator animator = ((HasAnimator)((Object)child)).getAnimator();
                animator.store(delay);
            }
            ++i2;
            b += 2;
        }
        parent.setSize(oldWidth, oldHeight);
        parent.invalidateHierarchy();
        App.root.validate();
        enabled = true;
        float offsetHeight = parent.getHeight() - oldHeight;
        int i3 = 0;
        int b2 = 0;
        while (i3 < n) {
            Actor child = (Actor)children.get(i3);
            if (child instanceof HasAnimator) {
                child.setX(before.get(b2));
                child.setY(before.get(b2 + 1) + offsetHeight);
            }
            ++i3;
            b2 += 2;
        }
    }

    public static boolean childrenAnimating(Group parent) {
        SnapshotArray<Actor> children = parent.getChildren();
        int i = 0;
        int n = children.size;
        while (i < n) {
            Actor child = (Actor)children.get(i);
            if (child instanceof HasAnimator) {
                Animator animator = ((HasAnimator)((Object)child)).getAnimator();
                if (animator.animating) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static interface HasAnimator {
        public Animator getAnimator();
    }
}

