/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tcpserver;

import com.esotericsoftware.minlog.Log;

public abstract class Retry {
    protected final String category;
    protected final String name;
    protected volatile boolean running;
    boolean daemon;
    final Object runLock = new Object();
    volatile Thread retryThread;
    int delayIndex;
    int[] retryDelays = new int[]{1000, 3000, 5000, 8000, 13000};

    public Retry(String category, String name) {
        this.category = category;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.runLock;
        synchronized (object) {
            this.stop();
            if (Log.TRACE) {
                Log.trace(this.category, "Started retry thread: " + this.name);
            }
            this.delayIndex = 0;
            this.running = true;
            this.retryThread = new Thread(this.name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            Retry.this.initialize();
                            while (Retry.this.running) {
                                Retry.this.retry();
                            }
                        }
                        catch (Throwable ex) {
                            throw new RuntimeException("Retry error: " + Retry.this.name, ex);
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = Retry.this.runLock;
                        synchronized (object) {
                            Retry.this.stop();
                            if (Log.TRACE) {
                                Log.trace(Retry.this.category, "Stopped retry thread: " + Retry.this.name);
                            }
                            Retry.this.stopped();
                            Retry.this.retryThread = null;
                            Retry.this.runLock.notifyAll();
                        }
                        throw throwable;
                    }
                    Object object = Retry.this.runLock;
                    synchronized (object) {
                        Retry.this.stop();
                        if (Log.TRACE) {
                            Log.trace(Retry.this.category, "Stopped retry thread: " + Retry.this.name);
                        }
                        Retry.this.stopped();
                        Retry.this.retryThread = null;
                        Retry.this.runLock.notifyAll();
                    }
                }
            };
            this.retryThread.setDaemon(this.daemon);
            this.retryThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.runLock;
        synchronized (object) {
            Thread retryThread;
            block10: {
                block9: {
                    if (this.running) break block9;
                    return false;
                }
                this.running = false;
                retryThread = this.retryThread;
                if (retryThread != Thread.currentThread()) break block10;
                return true;
            }
            if (Log.TRACE) {
                Log.trace(this.category, "Waiting for retry thread to stop: " + this.name);
            }
            retryThread.interrupt();
            this.stopped();
            while (this.retryThread == retryThread) {
                try {
                    this.runLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    protected void initialize() {
    }

    protected abstract void retry();

    protected void stopped() {
    }

    protected void success() {
        this.delayIndex = 0;
    }

    protected void failed() {
        if (this.retryDelays[this.delayIndex] == 0) {
            throw new RuntimeException("Retry thread failed: " + this.name);
        }
        try {
            Thread.sleep(this.retryDelays[this.delayIndex]);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ++this.delayIndex;
        if (this.delayIndex >= this.retryDelays.length) {
            this.delayIndex = 0;
        }
    }

    public void setRetryDelays(int ... retryDelays) {
        this.retryDelays = retryDelays;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }
}

