/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCacheService
implements BuildCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCacheService.class);
    static final String BUILD_CACHE_CONTENT_TYPE = "application/vnd.gradle.build-cache-artifact.v1";
    private static final Set<Integer> FATAL_HTTP_ERROR_CODES = ImmutableSet.of((Object)305, (Object)400, (Object)401, (Object)403, (Object)407, (Object)405, (Object[])new Integer[]{406, 411, 415, 417, 426, 505, 511});
    private final URI root;
    private final HttpClientHelper httpClientHelper;

    public HttpBuildCacheService(HttpClientHelper httpClientHelper, URI url) {
        if (!url.getPath().endsWith("/")) {
            throw new IncompleteArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = url;
        this.httpClientHelper = httpClientHelper;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        boolean bl;
        String defaultMessage;
        int statusCode;
        CloseableHttpResponse response;
        block10: {
            StatusLine statusLine;
            URI uri;
            block9: {
                block8: {
                    uri = this.root.resolve("./" + key.getHashCode());
                    HttpGet httpGet = new HttpGet(uri);
                    httpGet.addHeader("Accept", "application/vnd.gradle.build-cache-artifact.v1, */*");
                    this.addDiagnosticHeaders((HttpMessage)httpGet);
                    response = null;
                    response = this.httpClientHelper.performHttpRequest((HttpRequestBase)httpGet);
                    statusLine = response.getStatusLine();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
                    }
                    if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) break block8;
                    reader.readFrom(response.getEntity().getContent());
                    boolean bl2 = true;
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                    return bl2;
                }
                if (statusCode != 404) break block9;
                boolean bl3 = false;
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                return bl3;
            }
            defaultMessage = String.format("Loading entry from '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase());
            if (!this.isRedirect(statusCode)) break block10;
            boolean bl4 = this.handleRedirect(uri, response, statusCode, defaultMessage, "loading entry from");
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            return bl4;
        }
        try {
            bl = this.throwHttpStatusCodeException(statusCode, defaultMessage);
        }
        catch (IOException e) {
            try {
                throw HttpBuildCacheService.wrap(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        return bl;
    }

    private boolean handleRedirect(URI uri, CloseableHttpResponse response, int statusCode, String defaultMessage, String action) {
        Header locationHeader = response.getFirstHeader("location");
        if (locationHeader == null) {
            return this.throwHttpStatusCodeException(statusCode, defaultMessage);
        }
        try {
            throw new BuildCacheException(String.format("Received unexpected redirect (HTTP %d) to %s when " + action + " '%s'. " + "Ensure the configured URL for the remote build cache is correct.", statusCode, HttpBuildCacheService.safeUri(new URI(locationHeader.getValue())), HttpBuildCacheService.safeUri(uri)));
        }
        catch (URISyntaxException e) {
            return this.throwHttpStatusCodeException(statusCode, defaultMessage);
        }
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 307;
    }

    private void addDiagnosticHeaders(HttpMessage request) {
        request.addHeader("X-Gradle-Version", GradleVersion.current().getVersion());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(BuildCacheKey key, final BuildCacheEntryWriter output) throws BuildCacheException {
        CloseableHttpResponse response;
        block8: {
            URI uri = this.root.resolve(key.getHashCode());
            HttpPut httpPut = new HttpPut(uri);
            httpPut.addHeader("Content-Type", BUILD_CACHE_CONTENT_TYPE);
            this.addDiagnosticHeaders((HttpMessage)httpPut);
            httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return output.getSize();
                }

                public InputStream getContent() throws IOException, UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    output.writeTo(outstream);
                }

                public boolean isStreaming() {
                    return false;
                }
            });
            response = null;
            try {
                int statusCode;
                response = this.httpClientHelper.performHttpRequest((HttpRequestBase)httpPut);
                StatusLine statusLine = response.getStatusLine();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
                }
                if (this.isHttpSuccess(statusCode = statusLine.getStatusCode())) break block8;
                String defaultMessage = String.format("Storing entry at '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase());
                if (this.isRedirect(statusCode)) {
                    this.handleRedirect(uri, response, statusCode, defaultMessage, "storing entry at");
                } else {
                    this.throwHttpStatusCodeException(statusCode, defaultMessage);
                }
            }
            catch (ClientProtocolException e) {
                try {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof NonRepeatableRequestException)) throw HttpBuildCacheService.wrap(cause);
                    throw HttpBuildCacheService.wrap(cause.getCause());
                    catch (IOException e2) {
                        throw HttpBuildCacheService.wrap(e2);
                    }
                }
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(response);
                    throw throwable;
                }
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
    }

    private static BuildCacheException wrap(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new BuildCacheException(e.getMessage(), e);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean throwHttpStatusCodeException(int statusCode, String message) {
        if (FATAL_HTTP_ERROR_CODES.contains(statusCode)) {
            throw new UncheckedIOException(message);
        }
        throw new BuildCacheException(message);
    }

    public void close() throws IOException {
        this.httpClientHelper.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

