/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class StringTokenizer
implements Enumeration<String> {
    private int currentPosition;
    private int newPosition;
    private int maxPosition;
    private String str;
    private String delimiters;
    private final boolean retDelims;
    private boolean delimsChanged;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c = this.delimiters.charAt(i);
            if (m >= c) continue;
            m = c;
        }
        this.maxDelimChar = m;
    }

    public StringTokenizer(@NotNull String str, @NotNull String delim, boolean returnDelims) {
        if (str == null) {
            StringTokenizer.$$$reportNull$$$0(0);
        }
        if (delim == null) {
            StringTokenizer.$$$reportNull$$$0(1);
        }
        this.currentPosition = 0;
        this.newPosition = -1;
        this.delimsChanged = false;
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public StringTokenizer(@NotNull String str, @NotNull String delim) {
        if (str == null) {
            StringTokenizer.$$$reportNull$$$0(2);
        }
        if (delim == null) {
            StringTokenizer.$$$reportNull$$$0(3);
        }
        this(str, delim, false);
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; !this.retDelims && position < this.maxPosition && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && ((c = this.str.charAt(position)) > this.maxDelimChar || this.delimiters.indexOf(c) < 0); ++position) {
        }
        if (this.retDelims && startPos == position && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    @NotNull
    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        String string = this.str.substring(start, this.currentPosition);
        if (string == null) {
            StringTokenizer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    @NotNull
    public String nextElement() {
        String string = this.nextToken();
        if (string == null) {
            StringTokenizer.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/text/StringTokenizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/text/StringTokenizer";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nextToken";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nextToken";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

