/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.notify;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.notify.BuildOperationFinishedNotification;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationStartedNotification;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.BuildOperationListenerManager;
import org.gradle.internal.progress.OperationFinishEvent;
import org.gradle.internal.progress.OperationStartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildOperationNotificationBridge
implements BuildOperationNotificationListenerRegistrar,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildOperationNotificationBridge.class);
    private final RecordingBuildOperationNotificationListener recordingListener;
    private final BuildOperationListenerManager listenerManager;
    private BuildOperationListener transformingListener;
    private BuildOperationNotificationListener registeredListener;
    private boolean stopped;

    BuildOperationNotificationBridge(BuildOperationListenerManager buildOperationListenerManager) {
        this.listenerManager = buildOperationListenerManager;
        this.recordingListener = new RecordingBuildOperationNotificationListener();
        this.transformingListener = new TransformingListener(this.recordingListener);
    }

    public void start(GradleInternal gradle) {
        this.listenerManager.addListener(this.transformingListener);
        gradle.rootProject((Action)new Action<Project>(){

            public void execute(Project project) {
                project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        if (BuildOperationNotificationBridge.this.registeredListener == null) {
                            BuildOperationNotificationBridge.this.stop();
                        }
                    }
                });
            }
        });
    }

    public void registerBuildScopeListener(BuildOperationNotificationListener notificationListener) {
        this.preventDuplicateRegistration(notificationListener);
        this.listenerManager.removeListener(this.transformingListener);
        this.recordingListener.stop();
        this.transformingListener = new TransformingListener(notificationListener);
        this.listenerManager.addListener(this.transformingListener);
    }

    public void registerBuildScopeListenerAndReceiveStoredOperations(BuildOperationNotificationListener notificationListener) {
        this.preventDuplicateRegistration(notificationListener);
        this.recordingListener.replayAndAttach(notificationListener);
    }

    private void preventDuplicateRegistration(BuildOperationNotificationListener notificationListener) {
        if (this.registeredListener != null) {
            throw new IllegalStateException("listener is already registered (implementation class " + this.registeredListener.getClass().getName() + ")");
        }
        this.registeredListener = notificationListener;
    }

    public void stop() {
        if (!this.stopped) {
            this.listenerManager.removeListener(this.transformingListener);
            this.recordingListener.stop();
            this.stopped = true;
        }
    }

    private static class Finished
    implements BuildOperationFinishedNotification {
        private final long timestamp;
        private final Object id;
        private final Object parentId;
        private final Object details;
        private final Object result;
        private final Throwable failure;

        private Finished(long timestamp, Object id, Object parentId, Object details, Object result, Throwable failure) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
            this.result = result;
            this.failure = failure;
        }

        public long getNotificationOperationFinishedTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        @Nullable
        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public Object getNotificationOperationResult() {
            return this.result;
        }

        public Throwable getNotificationOperationFailure() {
            return this.failure;
        }

        public String toString() {
            return "BuildOperationFinishedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + ", result=" + this.result + ", failure=" + this.failure + '}';
        }
    }

    private static class Started
    implements BuildOperationStartedNotification {
        private final long timestamp;
        private final Object id;
        private final Object parentId;
        private final Object details;

        private Started(long timestamp, Object id, Object parentId, Object details) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
        }

        public long getNotificationOperationStartedTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public String toString() {
            return "BuildOperationStartedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + '}';
        }
    }

    private static class RecordingBuildOperationNotificationListener
    implements BuildOperationNotificationListener {
        private List<Object> storedEvents = Lists.newArrayList();
        private BuildOperationNotificationListener delegate;

        private RecordingBuildOperationNotificationListener() {
        }

        synchronized void replayAndAttach(BuildOperationNotificationListener listener) {
            this.delegate = listener;
            for (Object storedEvent : this.storedEvents) {
                if (storedEvent instanceof BuildOperationStartedNotification) {
                    this.delegate.started((BuildOperationStartedNotification)storedEvent);
                    continue;
                }
                this.delegate.finished((BuildOperationFinishedNotification)storedEvent);
            }
            this.storedEvents = null;
        }

        public boolean isActive() {
            return this.delegate != null;
        }

        public synchronized void started(BuildOperationStartedNotification notification) {
            if (this.isActive()) {
                this.delegate.started(notification);
            } else {
                this.storedEvents.add(notification);
            }
        }

        public synchronized void finished(BuildOperationFinishedNotification notification) {
            if (this.isActive()) {
                this.delegate.finished(notification);
            } else {
                this.storedEvents.add(notification);
            }
        }

        public void stop() {
            this.delegate = null;
            this.storedEvents = null;
        }
    }

    private static class TransformingListener
    implements BuildOperationListener {
        private final BuildOperationNotificationListener notificationListener;
        private final Map<Object, Object> parents = new ConcurrentHashMap<Object, Object>();
        private final Map<Object, Object> active = new ConcurrentHashMap<Object, Object>();

        private TransformingListener(BuildOperationNotificationListener notificationListener) {
            this.notificationListener = notificationListener;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            Object id = buildOperation.getId();
            Object parentId = buildOperation.getParentId();
            if (parentId != null) {
                if (this.active.containsKey(parentId)) {
                    this.parents.put(id, parentId);
                } else if ((parentId = this.parents.get(parentId)) != null) {
                    this.parents.put(id, parentId);
                }
            }
            if (buildOperation.getDetails() == null) {
                return;
            }
            this.active.put(id, "");
            Started notification = new Started(startEvent.getStartTime(), id, parentId, buildOperation.getDetails());
            try {
                this.notificationListener.started((BuildOperationStartedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }

        private void maybeThrow(Throwable e) {
            if (e instanceof Error && !(e instanceof LinkageError)) {
                throw (Error)e;
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            Object id = buildOperation.getId();
            Object parentId = this.parents.remove(id);
            if (this.active.remove(id) == null) {
                return;
            }
            Finished notification = new Finished(finishEvent.getEndTime(), id, parentId, buildOperation.getDetails(), finishEvent.getResult(), finishEvent.getFailure());
            try {
                this.notificationListener.finished((BuildOperationFinishedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }
    }
}

