/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.tasks.internal.XcodeSchemeFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;

@Incubating
public class GenerateSchemeFileTask
extends XmlGeneratorTask<XcodeSchemeFile> {
    public DefaultXcodeProject xcodeProject;

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }

    protected void configure(XcodeSchemeFile schemeFile) {
        this.configureBuildAction(schemeFile.getBuildAction());
        this.configureTestAction(schemeFile.getTestAction());
        this.configureLaunchAction(schemeFile.getLaunchAction());
        this.configureArchiveAction(schemeFile.getArchiveAction());
        this.configureAnalyzeAction(schemeFile.getAnalyzeAction());
        this.configureProfileAction(schemeFile.getProfileAction());
    }

    private void configureBuildAction(XcodeSchemeFile.BuildAction action) {
        action.entry(new Action<XcodeSchemeFile.BuildActionEntry>(){

            public void execute(XcodeSchemeFile.BuildActionEntry buildActionEntry) {
                buildActionEntry.setBuildForAnalysing(true);
                buildActionEntry.setBuildForArchiving(true);
                buildActionEntry.setBuildForProfiling(true);
                buildActionEntry.setBuildForRunning(true);
                buildActionEntry.setBuildForTesting(true);
                buildActionEntry.setBuildableReference(GenerateSchemeFileTask.this.toBuildableReference(GenerateSchemeFileTask.this.xcodeProject.getTarget()));
            }
        });
    }

    private void configureTestAction(XcodeSchemeFile.TestAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureLaunchAction(XcodeSchemeFile.LaunchAction action) {
        action.setBuildConfiguration("Debug");
        action.setRunnablePath(((RegularFile)this.xcodeProject.getTarget().getOutputFile().get()).getAsFile().getAbsolutePath());
    }

    private void configureArchiveAction(XcodeSchemeFile.ArchiveAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureProfileAction(XcodeSchemeFile.ProfileAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureAnalyzeAction(XcodeSchemeFile.AnalyzeAction action) {
        action.setBuildConfiguration("Debug");
    }

    protected XcodeSchemeFile create() {
        return new XcodeSchemeFile(this.getXmlTransformer());
    }

    private XcodeSchemeFile.BuildableReference toBuildableReference(XcodeTarget target) {
        XcodeSchemeFile.BuildableReference buildableReference = new XcodeSchemeFile.BuildableReference();
        buildableReference.setBuildableIdentifier("primary");
        buildableReference.setBlueprintIdentifier(target.getId());
        buildableReference.setBuildableName(target.getName());
        buildableReference.setBlueprintName(target.getName());
        buildableReference.setContainerRelativePath(this.getProject().getName() + ".xcodeproj");
        return buildableReference;
    }
}

