/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestMethodDetecter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;

class JUnitTestClassDetecter
extends TestClassVisitor {
    private boolean isAbstract;
    private String className;
    private String superClassName;
    private boolean test;

    JUnitTestClassDetecter(TestFrameworkDetector detector) {
        super(detector);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAbstract = (access & 0x400) != 0;
        this.className = name;
        this.superClassName = superName;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.equals(this.className) && (access & 8) == 0) {
            this.isAbstract = true;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if ("Lorg/junit/runner/RunWith;".equals(desc)) {
            this.test = true;
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.test) {
            return new JUnitTestMethodDetecter(this);
        }
        return null;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    void setTest(boolean test) {
        this.test = test;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }
}

