/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultImmutableAttributes;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultImmutableAttributesFactory
implements ImmutableAttributesFactory {
    private final ImmutableAttributes root;
    private final Map<ImmutableAttributes, List<DefaultImmutableAttributes>> children;
    private final IsolatableFactory isolatableFactory;

    public DefaultImmutableAttributesFactory(IsolatableFactory isolatableFactory) {
        this.isolatableFactory = isolatableFactory;
        this.root = ImmutableAttributes.EMPTY;
        this.children = Maps.newHashMap();
        this.children.put(this.root, new ArrayList());
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public AttributeContainerInternal mutable() {
        return new DefaultMutableAttributeContainer(this);
    }

    @Override
    public AttributeContainerInternal mutable(AttributeContainerInternal parent) {
        return new DefaultMutableAttributeContainer(this, parent);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.concat(this.root, key, value);
    }

    @Override
    public synchronized <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, T value) {
        ArrayList nodeChildren = this.children.get(node);
        if (nodeChildren == null) {
            nodeChildren = Lists.newArrayList();
            this.children.put(node, nodeChildren);
        }
        for (DefaultImmutableAttributes child : nodeChildren) {
            if (!child.attribute.equals(key) || !child.value.isolate().equals(value)) continue;
            return child;
        }
        DefaultImmutableAttributes child = new DefaultImmutableAttributes((DefaultImmutableAttributes)node, key, this.isolatableFactory.isolate(value));
        nodeChildren.add(child);
        return child;
    }

    public ImmutableAttributes getRoot() {
        return this.root;
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) {
        ImmutableAttributes current = attributes2;
        for (Attribute attribute : attributes1.keySet()) {
            if (current.contains(attribute)) continue;
            current = this.concat(current, attribute, attributes1.getAttribute(attribute));
        }
        return current;
    }
}

