/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.internal.ModuleMetadataFileGenerator;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;

@Incubating
public class GenerateModuleMetadata
extends DefaultTask {
    private final Property<Publication> publication = this.getProject().getObjects().property(Publication.class);
    private final RegularFileProperty outputFile = this.newOutputFile();

    public GenerateModuleMetadata() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @Internal
    public Property<Publication> getPublication() {
        return this.publication;
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void run() {
        File file = ((RegularFile)this.outputFile.get()).getAsFile();
        PublicationInternal publication = (PublicationInternal)this.publication.get();
        ComponentWithVariants component = (ComponentWithVariants)publication.getComponent();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8"));){
            new ModuleMetadataFileGenerator((BuildInvocationScopeId)this.getServices().get(BuildInvocationScopeId.class)).generateTo(publication.getCoordinates(), component, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate metadata file " + this.outputFile.getAsFile(), (Throwable)e);
        }
    }
}

