/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.plugins;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectLocalComponentProvider;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.xcode.XcodeExtension;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeExtension;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.FileTypes;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.tasks.GenerateSchemeFileTask;
import org.gradle.ide.xcode.tasks.GenerateWorkspaceSettingsFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeProjectFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeWorkspaceFileTask;
import org.gradle.initialization.ProjectPathRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.plugins.CppExecutablePlugin;
import org.gradle.language.cpp.plugins.CppLibraryPlugin;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.plugins.SwiftExecutablePlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.language.swift.tasks.CreateSwiftBundle;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.plugins.XCTestConventionPlugin;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

@Incubating
public class XcodePlugin
extends IdePlugin {
    private final GidGenerator gidGenerator;
    private final ObjectFactory objectFactory;
    private final ProjectLayout projectLayout;
    private DefaultXcodeExtension xcode;
    private GenerateXcodeWorkspaceFileTask workspaceTask;
    private GenerateXcodeProjectFileTask projectTask;

    @Inject
    public XcodePlugin(GidGenerator gidGenerator, ObjectFactory objectFactory, ProjectLayout projectLayout) {
        this.gidGenerator = gidGenerator;
        this.objectFactory = objectFactory;
        this.projectLayout = projectLayout;
    }

    protected String getLifecycleTaskName() {
        return "xcode";
    }

    protected void onApply(Project project) {
        this.getLifecycleTask().setDescription("Generates XCode project files (pbxproj, xcworkspace, xcscheme)");
        this.getCleanTask().setDescription("Cleans XCode project files (xcodeproj)");
        this.xcode = (DefaultXcodeExtension)project.getExtensions().create(XcodeExtension.class, "xcode", DefaultXcodeExtension.class, new Object[]{this.objectFactory});
        this.xcode.getProject().setLocationDir(project.file((Object)(project.getName() + ".xcodeproj")));
        this.projectTask = this.createProjectTask(project);
        this.workspaceTask = this.createWorkspaceTask(project);
        if (this.getWorkspaceTask() != null) {
            this.getLifecycleTask().dependsOn(new Object[]{this.getWorkspaceTask()});
        }
        this.getLifecycleTask().dependsOn(new Object[]{this.getProjectTask()});
        this.configureForSwiftPlugin(project);
        this.configureForCppPlugin(project);
        this.includeBuildFileInProject(project);
        this.configureXcodeCleanTask(project);
        this.registerXcodeProjectArtifact(project);
        this.addIncludedBuildToWorkspace(project);
    }

    private GenerateXcodeProjectFileTask getProjectTask() {
        return this.projectTask;
    }

    private GenerateXcodeWorkspaceFileTask getWorkspaceTask() {
        return this.workspaceTask;
    }

    private void includeBuildFileInProject(Project project) {
        if (project.getBuildFile().exists()) {
            this.xcode.getProject().addSourceFile(project.getBuildFile());
        }
    }

    private void configureXcodeCleanTask(Project project) {
        Delete cleanTask = (Delete)project.getTasks().create("cleanXcodeProject", Delete.class);
        cleanTask.delete(new Object[]{this.xcode.getProject().getLocationDir()});
        if (XcodePlugin.isRoot(project)) {
            cleanTask.delete(new Object[]{XcodePlugin.toXcodeWorkspacePackageDir(project)});
        }
        this.getCleanTask().dependsOn(new Object[]{cleanTask});
    }

    private GenerateXcodeProjectFileTask createProjectTask(Project project) {
        File xcodeProjectPackageDir = this.xcode.getProject().getLocationDir();
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = (GenerateWorkspaceSettingsFileTask)project.getTasks().create("xcodeProjectWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeProjectFileTask projectFileTask = (GenerateXcodeProjectFileTask)project.getTasks().create("xcodeProject", GenerateXcodeProjectFileTask.class);
        projectFileTask.dependsOn(new Object[]{workspaceSettingsFileTask});
        projectFileTask.setXcodeProject(this.xcode.getProject());
        projectFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.pbxproj"));
        return projectFileTask;
    }

    private GenerateXcodeWorkspaceFileTask createWorkspaceTask(Project project) {
        if (XcodePlugin.isRoot(project)) {
            File xcodeWorkspacePackageDir = XcodePlugin.toXcodeWorkspacePackageDir(project);
            GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = (GenerateWorkspaceSettingsFileTask)project.getTasks().create("xcodeWorkspaceWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
            workspaceSettingsFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "xcshareddata/WorkspaceSettings.xcsettings"));
            GenerateXcodeWorkspaceFileTask workspaceFileTask = (GenerateXcodeWorkspaceFileTask)project.getTasks().create("xcodeWorkspace", GenerateXcodeWorkspaceFileTask.class);
            workspaceFileTask.dependsOn(new Object[]{workspaceSettingsFileTask});
            workspaceFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "contents.xcworkspacedata"));
            return workspaceFileTask;
        }
        return null;
    }

    private static XcodeExtension xcodeModelFor(Project project) {
        return (XcodeExtension)project.getExtensions().getByType(XcodeExtension.class);
    }

    private void configureForSwiftPlugin(final Project project) {
        project.getPlugins().withType(SwiftExecutablePlugin.class, (Action)new Action<SwiftExecutablePlugin>(){

            public void execute(SwiftExecutablePlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project, PBXTarget.ProductType.TOOL);
            }
        });
        project.getPlugins().withType(SwiftLibraryPlugin.class, (Action)new Action<SwiftLibraryPlugin>(){

            public void execute(SwiftLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project, PBXTarget.ProductType.DYNAMIC_LIBRARY);
            }
        });
        project.getPlugins().withType(XCTestConventionPlugin.class, (Action)new Action<XCTestConventionPlugin>(){

            public void execute(XCTestConventionPlugin plugin) {
                XcodePlugin.this.configureXcodeForXCTest(project, PBXTarget.ProductType.UNIT_TEST);
            }
        });
    }

    private void configureXcodeForXCTest(final Project project, PBXTarget.ProductType productType) {
        SwiftXCTestSuite component = (SwiftXCTestSuite)project.getExtensions().getByType(SwiftXCTestSuite.class);
        FileCollection sources = component.getSwiftSource();
        this.xcode.getProject().getSources().from(new Object[]{sources});
        final CreateSwiftBundle bundleDebug = (CreateSwiftBundle)project.getTasks().getByName("bundleSwiftTest");
        this.xcode.getProject().getSources().from(new Object[]{bundleDebug.getInformationFile()});
        final Sync syncTask = (Sync)project.getTasks().create("sync" + GUtil.toCamelCase((CharSequence)component.getName()) + "BundleToXcodeBuiltProductDir", Sync.class, (Action)new Action<Sync>(){

            public void execute(Sync task) {
                final DirectoryProperty builtProductsDir = XcodePlugin.this.getBuiltProductsDir();
                task.onlyIf((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task element) {
                        return builtProductsDir.isPresent();
                    }
                });
                task.from(new Object[]{bundleDebug});
                task.into((Object)builtProductsDir.dir(project.provider((Callable)new Callable<CharSequence>(){

                    @Override
                    public CharSequence call() throws Exception {
                        return ((File)bundleDebug.getOutputDir().getAsFile().get()).getName();
                    }
                })));
            }
        });
        project.getTasks().create("buildXcode" + GUtil.toCamelCase((CharSequence)component.getName()) + "Product", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{syncTask});
            }
        });
        String taskName = project.getPath() + ":${ACTION}Xcode" + GUtil.toCamelCase((CharSequence)component.getName());
        XcodeTarget target = this.newTarget((String)component.getModule().get() + " " + XcodePlugin.toString(productType), (String)component.getModule().get(), productType, XcodePlugin.toGradleCommand(project.getRootProject()), taskName, (Provider<? extends FileSystemLocation>)bundleDebug.getOutputDir(), (Provider<? extends FileSystemLocation>)bundleDebug.getOutputDir(), sources);
        target.getImportPaths().from(new Object[]{component.getDevelopmentBinary().getCompileImportPath()});
        this.xcode.getProject().addTarget(target);
    }

    private DirectoryProperty getBuiltProductsDir() {
        DirectoryProperty result = this.projectLayout.directoryProperty();
        String builtProductsPath = System.getenv("BUILT_PRODUCTS_DIR");
        if (builtProductsPath != null) {
            result.set(new File(builtProductsPath));
        }
        return result;
    }

    private void configureXcodeForSwift(Project project, PBXTarget.ProductType productType) {
        SwiftComponent component = (SwiftComponent)project.getExtensions().getByType(SwiftComponent.class);
        FileCollection sources = component.getSwiftSource();
        this.xcode.getProject().getSources().from(new Object[]{sources});
        AbstractLinkTask linkDebug = (AbstractLinkTask)project.getTasks().getByName("linkDebug");
        AbstractLinkTask linkRelease = (AbstractLinkTask)project.getTasks().getByName("linkRelease");
        String taskName = project.getPath() + ":link$(CONFIGURATION)";
        XcodeTarget target = this.newTarget((String)component.getModule().get() + " " + XcodePlugin.toString(productType), (String)component.getModule().get(), productType, XcodePlugin.toGradleCommand(project.getRootProject()), taskName, (Provider<? extends FileSystemLocation>)linkDebug.getBinaryFile(), (Provider<? extends FileSystemLocation>)linkRelease.getBinaryFile(), sources);
        target.getImportPaths().from(new Object[]{component.getDevelopmentBinary().getCompileImportPath()});
        this.xcode.getProject().addTarget(target);
        this.getProjectTask().dependsOn(new Object[]{XcodePlugin.createSchemeTask(project.getTasks(), (String)component.getModule().get() + " " + XcodePlugin.toString(productType), this.xcode.getProject())});
    }

    private void configureForCppPlugin(final Project project) {
        project.getPlugins().withType(CppExecutablePlugin.class, (Action)new Action<CppExecutablePlugin>(){

            public void execute(CppExecutablePlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project, PBXTarget.ProductType.TOOL);
            }
        });
        project.getPlugins().withType(CppLibraryPlugin.class, (Action)new Action<CppLibraryPlugin>(){

            public void execute(CppLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project, PBXTarget.ProductType.DYNAMIC_LIBRARY);
            }
        });
    }

    private void configureXcodeForCpp(Project project, PBXTarget.ProductType productType) {
        CppComponent component = (CppComponent)project.getExtensions().getByType(CppComponent.class);
        FileCollection sources = component.getCppSource();
        this.xcode.getProject().getSources().from(new Object[]{sources});
        FileTree headers = component.getHeaderFiles();
        this.xcode.getProject().getSources().from(new Object[]{headers});
        AbstractLinkTask linkDebug = (AbstractLinkTask)project.getTasks().getByName("linkDebug");
        AbstractLinkTask linkRelease = (AbstractLinkTask)project.getTasks().getByName("linkRelease");
        String targetName = StringUtils.capitalize((String)project.getName());
        String taskName = project.getPath() + ":link$(CONFIGURATION)";
        XcodeTarget target = this.newTarget(targetName + " " + XcodePlugin.toString(productType), targetName, productType, XcodePlugin.toGradleCommand(project.getRootProject()), taskName, (Provider<? extends FileSystemLocation>)linkDebug.getBinaryFile(), (Provider<? extends FileSystemLocation>)linkRelease.getBinaryFile(), sources);
        target.getHeaderSearchPaths().from(new Object[]{component.getDevelopmentBinary().getCompileIncludePath()});
        this.xcode.getProject().addTarget(target);
        this.getProjectTask().dependsOn(new Object[]{XcodePlugin.createSchemeTask(project.getTasks(), targetName + " " + XcodePlugin.toString(productType), this.xcode.getProject())});
    }

    private static GenerateSchemeFileTask createSchemeTask(TaskContainer tasks, String schemeName, DefaultXcodeProject xcodeProject) {
        String name = "xcodeScheme" + schemeName.replaceAll(" ", "");
        GenerateSchemeFileTask schemeFileTask = (GenerateSchemeFileTask)((Object)tasks.maybeCreate(name, GenerateSchemeFileTask.class));
        schemeFileTask.setXcodeProject(xcodeProject);
        schemeFileTask.setOutputFile(new File(xcodeProject.getLocationDir(), "xcshareddata/xcschemes/" + schemeName + ".xcscheme"));
        return schemeFileTask;
    }

    private static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional gradleWrapperPath = Optional.absent();
        if (project.file((Object)"gradlew").exists()) {
            gradleWrapperPath = Optional.of((Object)project.file((Object)"gradlew").getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or((Object)"gradle");
    }

    private XcodeTarget newTarget(String name, String productName, PBXTarget.ProductType productType, String gradleCommand, String taskName, Provider<? extends FileSystemLocation> debugBinaryFile, Provider<? extends FileSystemLocation> releaseBinaryFile, FileCollection sources) {
        String id = this.gidGenerator.generateGid("PBXLegacyTarget", name.hashCode());
        XcodeTarget target = (XcodeTarget)this.objectFactory.newInstance(XcodeTarget.class, new Object[]{name, id});
        target.getDebugOutputFile().set(debugBinaryFile);
        target.getReleaseOutputFile().set(releaseBinaryFile);
        target.setTaskName(taskName);
        target.setGradleCommand(gradleCommand);
        target.setOutputFileType(XcodePlugin.toFileType(productType));
        target.setProductType(productType);
        target.setProductName(productName);
        target.getSources().setFrom((Iterable)sources);
        return target;
    }

    private static File toXcodeWorkspacePackageDir(Project project) {
        return project.file((Object)(project.getName() + ".xcworkspace"));
    }

    private static String toString(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return "Executable";
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return "SharedLibrary";
        }
        if (PBXTarget.ProductType.UNIT_TEST.equals((Object)productType)) {
            return "XCTestBundle";
        }
        return "";
    }

    private static String toFileType(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return FileTypes.MACH_O_EXECUTABLE.identifier;
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return FileTypes.MACH_O_DYNAMIC_LIBRARY.identifier;
        }
        return "compiled";
    }

    private static boolean isRoot(Project project) {
        return project.getParent() == null;
    }

    private void registerXcodeProjectArtifact(Project project) {
        ProjectLocalComponentProvider projectComponentProvider = (ProjectLocalComponentProvider)((ProjectInternal)project).getServices().get(ProjectLocalComponentProvider.class);
        ProjectComponentIdentifier projectId = DefaultProjectComponentIdentifier.newProjectId((Project)project);
        projectComponentProvider.registerAdditionalArtifact(projectId, XcodePlugin.createXcodeProjectArtifact(projectId, XcodePlugin.xcodeModelFor(project), (Task)this.getProjectTask()));
    }

    private static LocalComponentArtifactMetadata createXcodeProjectArtifact(ProjectComponentIdentifier projectId, XcodeExtension xcode, Task projectTask) {
        XcodeProject xcodeProject = xcode.getProject();
        XcodeProjectArtifact publishArtifact = new XcodeProjectArtifact(xcodeProject, projectTask);
        return new PublishArtifactLocalArtifactMetadata((ComponentIdentifier)projectId, (PublishArtifact)publishArtifact);
    }

    private void addIncludedBuildToWorkspace(Project project) {
        if (XcodePlugin.isRoot(project)) {
            final ServiceRegistry serviceRegistry = ((ProjectInternal)project).getServices();
            this.getWorkspaceTask().dependsOn(new Object[]{new Callable<List<TaskDependency>>(){

                @Override
                public List<TaskDependency> call() throws Exception {
                    return CollectionUtils.collect((List)XcodePlugin.allXcodeprojArtifactsInComposite(serviceRegistry), (Transformer)new Transformer<TaskDependency, LocalComponentArtifactMetadata>(){

                        public TaskDependency transform(LocalComponentArtifactMetadata metadata) {
                            return metadata.getBuildDependencies();
                        }
                    });
                }
            }});
            this.getWorkspaceTask().setXcodeProjectLocations((FileCollection)project.files(new Object[]{new Callable<Iterable<File>>(){

                @Override
                public Iterable<File> call() throws Exception {
                    return CollectionUtils.collect((List)XcodePlugin.allXcodeprojArtifactsInComposite(serviceRegistry), (Transformer)new Transformer<File, LocalComponentArtifactMetadata>(){

                        public File transform(LocalComponentArtifactMetadata metadata) {
                            return metadata.getFile();
                        }
                    });
                }
            }}));
        }
    }

    private static List<LocalComponentArtifactMetadata> allXcodeprojArtifactsInComposite(ServiceRegistry serviceRegistry) {
        ArrayList artifactMetadata = Lists.newArrayList();
        ProjectPathRegistry projectPathRegistry = (ProjectPathRegistry)serviceRegistry.get(ProjectPathRegistry.class);
        LocalComponentRegistry localComponentRegistry = (LocalComponentRegistry)serviceRegistry.get(LocalComponentRegistry.class);
        for (Path projectPath : projectPathRegistry.getAllProjectPaths()) {
            ProjectComponentIdentifier projectId = projectPathRegistry.getProjectComponentIdentifier(projectPath);
            LocalComponentArtifactMetadata xcodeprojArtifact = localComponentRegistry.findAdditionalArtifact(projectId, "xcodeproj");
            if (xcodeprojArtifact == null) continue;
            artifactMetadata.add(xcodeprojArtifact);
        }
        return artifactMetadata;
    }

    private static class XcodeProjectArtifact
    extends DefaultPublishArtifact {
        private final DefaultXcodeProject xcodeProject;

        public XcodeProjectArtifact(XcodeProject xcodeProject, Object ... tasks) {
            super(null, "xcodeproj", "xcodeproj", null, null, null, tasks);
            this.xcodeProject = (DefaultXcodeProject)xcodeProject;
        }

        public String getName() {
            String fileName = this.xcodeProject.getLocationDir().getName();
            return fileName.substring(0, fileName.length() - ".xcodeproj".length());
        }

        public File getFile() {
            return this.xcodeProject.getLocationDir();
        }
    }
}

