/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginHandler
implements AutoAppliedPluginHandler {
    private final AutoAppliedPluginRegistry registry;

    public DefaultAutoAppliedPluginHandler(AutoAppliedPluginRegistry registry) {
        this.registry = registry;
    }

    public PluginRequests mergeWithAutoAppliedPlugins(PluginRequests initialRequests, Object pluginTarget) {
        if (!(pluginTarget instanceof Project)) {
            return initialRequests;
        }
        Project project = (Project)pluginTarget;
        ArrayList merged = Lists.newArrayList((Iterable)initialRequests);
        for (PluginRequestInternal autoAppliedPlugin : this.registry.getAutoAppliedPlugins(project)) {
            if (DefaultAutoAppliedPluginHandler.isAlreadyAppliedOrRequested(autoAppliedPlugin, initialRequests, project)) continue;
            merged.add(autoAppliedPlugin);
        }
        return new DefaultPluginRequests((List)merged);
    }

    private static boolean isAlreadyAppliedOrRequested(PluginRequestInternal autoAppliedPlugin, PluginRequests requests, Project project) {
        return DefaultAutoAppliedPluginHandler.isAlreadyApplied(autoAppliedPlugin, project) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInPluginsBlock(autoAppliedPlugin, requests) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInBuildScriptBlock(autoAppliedPlugin, project);
    }

    private static boolean isAlreadyApplied(PluginRequestInternal autoAppliedPlugin, Project project) {
        return project.getPlugins().hasPlugin(autoAppliedPlugin.getId().getId());
    }

    private static boolean isAlreadyRequestedInPluginsBlock(PluginRequestInternal autoAppliedPlugin, PluginRequests requests) {
        for (PluginRequestInternal request : requests) {
            if (!autoAppliedPlugin.getId().equals(request.getId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyRequestedInBuildScriptBlock(PluginRequestInternal autoAppliedPlugin, Project project) {
        ModuleVersionSelector module = autoAppliedPlugin.getModule();
        if (module == null) {
            return false;
        }
        Configuration classpathConfiguration = project.getBuildscript().getConfigurations().getByName("classpath");
        for (Dependency dependency : classpathConfiguration.getDependencies()) {
            if (!module.getGroup().equals(dependency.getGroup()) || !module.getName().equals(dependency.getName())) continue;
            return true;
        }
        return false;
    }
}

