/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantMetadata;

class DefaultConfigurationMetadata
implements ConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final String name;
    private final List<DefaultConfigurationMetadata> parents;
    private final List<DependencyMetadata> configDependencies = new ArrayList<DependencyMetadata>();
    private final Set<ComponentArtifactMetadata> artifacts = new LinkedHashSet<ComponentArtifactMetadata>();
    private final boolean transitive;
    private final boolean visible;
    private final List<String> hierarchy;
    private final List<Exclude> excludes;
    private ModuleExclusion exclusions;

    DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, List<DefaultConfigurationMetadata> parents, List<Exclude> excludes) {
        this.componentId = componentId;
        this.name = name;
        this.parents = parents;
        this.transitive = transitive;
        this.visible = visible;
        this.hierarchy = this.calculateHierarchy();
        this.excludes = excludes;
    }

    DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, List<Exclude> excludes) {
        this(componentId, name, transitive, visible, null, excludes);
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"configuration", (Object)this.name);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getHierarchy() {
        return this.hierarchy;
    }

    private List<String> calculateHierarchy() {
        if (this.parents == null) {
            return Collections.singletonList(this.name);
        }
        LinkedHashSet<String> hierarchy = new LinkedHashSet<String>(1 + this.parents.size());
        this.populateHierarchy(hierarchy);
        return ImmutableList.copyOf(hierarchy);
    }

    private void populateHierarchy(Set<String> accumulator) {
        accumulator.add(this.name);
        if (this.parents != null) {
            for (DefaultConfigurationMetadata parent : this.parents) {
                parent.populateHierarchy(accumulator);
            }
        }
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    public List<DependencyMetadata> getDependencies() {
        return this.configDependencies;
    }

    void populateDependencies(Iterable<? extends DependencyMetadata> dependencies) {
        for (DependencyMetadata dependencyMetadata : dependencies) {
            if (!this.include(dependencyMetadata)) continue;
            this.configDependencies.add(dependencyMetadata);
        }
    }

    private boolean include(DependencyMetadata dependency) {
        Collection<String> hierarchy = this.getHierarchy();
        for (String moduleConfiguration : dependency.getModuleConfigurations()) {
            if (moduleConfiguration.equals("%") || hierarchy.contains(moduleConfiguration)) {
                return true;
            }
            if (!moduleConfiguration.equals("*")) continue;
            boolean include = true;
            for (String conf2 : dependency.getModuleConfigurations()) {
                if (!conf2.startsWith("!") || !conf2.substring(1).equals(this.getName())) continue;
                include = false;
                break;
            }
            if (!include) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
        if (this.exclusions == null) {
            this.exclusions = this.filterExcludes(moduleExclusions, this.excludes);
        }
        return this.exclusions;
    }

    private ModuleExclusion filterExcludes(ModuleExclusions exclusions, Iterable<Exclude> excludes) {
        Collection<String> hierarchy = this.getHierarchy();
        ArrayList filtered = Lists.newArrayList();
        block0: for (Exclude exclude : excludes) {
            for (String config : exclude.getConfigurations()) {
                if (!hierarchy.contains(config)) continue;
                filtered.add(exclude);
                continue block0;
            }
        }
        return exclusions.excludeAny(filtered);
    }

    public Set<ComponentArtifactMetadata> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Set<? extends VariantMetadata> getVariants() {
        return ImmutableSet.of((Object)new DefaultVariantMetadata(this.asDescribable(), this.getAttributes(), this.getArtifacts()));
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    void collectInheritedArtifacts(Set<ConfigurationMetadata> visited) {
        if (!visited.add(this)) {
            return;
        }
        if (this.parents == null) {
            return;
        }
        for (DefaultConfigurationMetadata parent : this.parents) {
            parent.collectInheritedArtifacts(visited);
            this.artifacts.addAll(parent.artifacts);
        }
    }

    void addArtifacts(List<? extends ModuleComponentArtifactMetadata> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    void addArtifact(ModuleComponentArtifactMetadata artifact) {
        this.artifacts.add(artifact);
    }
}

