/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.initialization.ProjectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectSpec
implements ProjectSpec {
    @Override
    public boolean containsProject(ProjectRegistry<? extends ProjectIdentifier> registry) {
        this.checkPreconditions(registry);
        ArrayList matches = new ArrayList();
        this.select(registry, matches);
        return !matches.isEmpty();
    }

    @Override
    public <T extends ProjectIdentifier> T selectProject(ProjectRegistry<? extends T> registry) {
        this.checkPreconditions(registry);
        ArrayList matches = new ArrayList();
        this.select(registry, matches);
        if (matches.isEmpty()) {
            throw new InvalidUserDataException(this.formatNoMatchesMessage());
        }
        if (matches.size() != 1) {
            throw new InvalidUserDataException(this.formatMultipleMatchesMessage(matches));
        }
        return (T)((ProjectIdentifier)matches.get(0));
    }

    protected void checkPreconditions(ProjectRegistry<?> registry) {
    }

    protected abstract String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> var1);

    protected abstract String formatNoMatchesMessage();

    protected abstract <T extends ProjectIdentifier> void select(ProjectRegistry<? extends T> var1, List<? super T> var2);
}

