/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.ProgressEvent;
import org.gradle.tooling.ProgressListener;

class ProgressListenerToProgressLoggerAdapter
implements ProgressListener {
    private final ProgressLoggerFactory progressLoggerFactory;
    LinkedList<String> stack;
    Deque<ProgressLogger> loggerStack;

    public ProgressListenerToProgressLoggerAdapter(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.stack = new LinkedList();
        this.loggerStack = new ArrayDeque<ProgressLogger>();
    }

    public void statusChanged(ProgressEvent event) {
        String description = event.getDescription();
        if (description.equals("") || this.stack.size() >= 2 && this.stack.get(1).equals(description)) {
            this.loggerStack.pop().completed();
            this.stack.removeFirst();
            return;
        }
        this.stack.addFirst(description);
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(ProgressListenerToProgressLoggerAdapter.class);
        progressLogger.start(description, description);
        this.loggerStack.push(progressLogger);
    }
}

