/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;

@Incubating
public abstract class JacocoReportBase
extends JacocoBase {
    private FileCollection executionData;
    private FileCollection sourceDirectories;
    private FileCollection classDirectories;
    private FileCollection additionalClassDirs;
    private FileCollection additionalSourceDirs;

    public JacocoReportBase() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return Iterables.any((Iterable)JacocoReportBase.this.getExecutionData(), (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        return file.exists();
                    }
                });
            }
        });
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    public FileCollection getExecutionData() {
        return this.executionData;
    }

    public void setExecutionData(FileCollection executionData) {
        this.executionData = executionData;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(FileCollection sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getClassDirectories() {
        return this.classDirectories;
    }

    public void setClassDirectories(FileCollection classDirectories) {
        this.classDirectories = classDirectories;
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getAdditionalClassDirs() {
        return this.additionalClassDirs;
    }

    public void setAdditionalClassDirs(@Nullable FileCollection additionalClassDirs) {
        this.additionalClassDirs = additionalClassDirs;
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getAdditionalSourceDirs() {
        return this.additionalSourceDirs;
    }

    public void setAdditionalSourceDirs(@Nullable FileCollection additionalSourceDirs) {
        this.additionalSourceDirs = additionalSourceDirs;
    }

    public void executionData(Object ... files) {
        this.executionData = this.executionData == null ? this.getProject().files(files) : this.executionData.plus((FileCollection)this.getProject().files(files));
    }

    public void executionData(Task ... tasks) {
        for (Task task : tasks) {
            final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().findByType(JacocoTaskExtension.class);
            if (extension == null) continue;
            this.executionData(new Callable<File>(){

                @Override
                public File call() {
                    return extension.getDestinationFile();
                }
            });
            this.mustRunAfter(new Object[]{task});
        }
    }

    public void executionData(TaskCollection tasks) {
        tasks.all((Action)new Action<Task>(){

            public void execute(Task task) {
                JacocoReportBase.this.executionData(task);
            }
        });
    }

    @Internal
    public FileCollection getAllClassDirs() {
        FileCollection additionalDirs = this.getAdditionalClassDirs();
        if (additionalDirs == null) {
            return this.classDirectories;
        }
        return this.classDirectories.plus(this.getAdditionalClassDirs());
    }

    @Internal
    public FileCollection getAllSourceDirs() {
        FileCollection additionalDirs = this.getAdditionalSourceDirs();
        if (additionalDirs == null) {
            return this.sourceDirectories;
        }
        return this.sourceDirectories.plus(this.getAdditionalSourceDirs());
    }

    public void sourceSets(final SourceSet ... sourceSets) {
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                for (SourceSet sourceSet : sourceSets) {
                    if (JacocoReportBase.this.getSourceDirectories() == null) {
                        JacocoReportBase.this.setSourceDirectories((FileCollection)JacocoReportBase.this.getProject().files(new Object[]{sourceSet.getAllJava().getSrcDirs()}));
                    } else {
                        JacocoReportBase.this.setSourceDirectories(JacocoReportBase.this.getSourceDirectories().plus((FileCollection)JacocoReportBase.this.getProject().files(new Object[]{sourceSet.getAllJava().getSrcDirs()})));
                    }
                    if (JacocoReportBase.this.getClassDirectories() == null) {
                        JacocoReportBase.this.setClassDirectories((FileCollection)sourceSet.getOutput());
                        continue;
                    }
                    JacocoReportBase.this.setClassDirectories(JacocoReportBase.this.getClassDirectories().plus((FileCollection)sourceSet.getOutput()));
                }
            }
        });
    }

    public void additionalClassDirs(File ... dirs) {
        this.additionalClassDirs((FileCollection)this.getProject().files(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalClassDirs(FileCollection dirs) {
        this.additionalClassDirs = this.additionalClassDirs == null ? dirs : this.additionalClassDirs.plus(dirs);
    }

    public void additionalSourceDirs(File ... dirs) {
        this.additionalSourceDirs((FileCollection)this.getProject().files(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalSourceDirs(FileCollection dirs) {
        this.additionalSourceDirs = this.additionalSourceDirs == null ? dirs : this.additionalSourceDirs.plus(dirs);
    }
}

