/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.format;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.LogHeaderFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrefixedLogHeaderFormatter
implements LogHeaderFormatter {
    @Override
    public List<StyledTextOutputEvent.Span> format(@Nullable String header, String description, String status, boolean failed) {
        String message;
        String string = message = header != null ? header : description;
        if (status.isEmpty()) {
            return Lists.newArrayList((Object[])new StyledTextOutputEvent.Span[]{this.header(message, failed), StyledTextOutputEvent.EOL});
        }
        return Lists.newArrayList((Object[])new StyledTextOutputEvent.Span[]{this.header(message, failed), this.status(status, failed), StyledTextOutputEvent.EOL});
    }

    private StyledTextOutputEvent.Span header(String message, boolean failed) {
        StyledTextOutput.Style messageStyle = failed ? StyledTextOutput.Style.FailureHeader : StyledTextOutput.Style.Header;
        return new StyledTextOutputEvent.Span(messageStyle, "> " + message);
    }

    private StyledTextOutputEvent.Span status(String status, boolean failed) {
        StyledTextOutput.Style statusStyle = failed ? StyledTextOutput.Style.Failure : StyledTextOutput.Style.Info;
        return new StyledTextOutputEvent.Span(statusStyle, " " + status);
    }
}

