/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenPublisher
implements MavenPublisher {
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMavenPublisher.class);
    private final LocalMavenRepositoryLocator mavenRepositoryLocator;

    public AbstractMavenPublisher(Factory<LoggingManagerInternal> loggingManagerFactory, LocalMavenRepositoryLocator mavenRepositoryLocator) {
        this.loggingManagerFactory = loggingManagerFactory;
        this.mavenRepositoryLocator = mavenRepositoryLocator;
    }

    @Override
    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        if (artifactRepository == null) {
            LOGGER.info("Publishing to maven local repository");
        } else {
            LOGGER.info("Publishing to repository '{}' ({})", (Object)artifactRepository.getName(), (Object)artifactRepository.getUrl());
        }
        MavenPublishAction deployTask = this.createDeployTask(publication.getPomFile(), publication.getMetadataFile(), this.mavenRepositoryLocator, artifactRepository);
        this.addPomAndArtifacts(deployTask, publication);
        this.execute(deployTask);
    }

    protected abstract MavenPublishAction createDeployTask(File var1, File var2, LocalMavenRepositoryLocator var3, MavenArtifactRepository var4);

    private void addPomAndArtifacts(MavenPublishAction publishAction, MavenNormalizedPublication publication) {
        MavenArtifact mainArtifact = publication.getMainArtifact();
        if (mainArtifact != null) {
            publishAction.setMainArtifact(mainArtifact.getFile());
        }
        for (MavenArtifact mavenArtifact : publication.getArtifacts()) {
            if (mavenArtifact == mainArtifact) continue;
            publishAction.addAdditionalArtifact(mavenArtifact.getFile(), (String)GUtil.elvis((Object)mavenArtifact.getExtension(), (Object)""), (String)GUtil.elvis((Object)mavenArtifact.getClassifier(), (Object)""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(MavenPublishAction publishAction) {
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)this.loggingManagerFactory.create();
        loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            publishAction.publish();
        }
        finally {
            loggingManager.stop();
        }
    }
}

