/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.Collection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;

class DirectDependencyForcingResolver
implements ModuleConflictResolver {
    private final ComponentState root;

    DirectDependencyForcingResolver(ComponentState root) {
        this.root = root;
    }

    @Override
    public <T extends ComponentResolutionState> void select(ConflictResolverDetails<T> details) {
        Collection<T> candidates = details.getCandidates();
        for (NodeState configuration : this.root.getNodes()) {
            for (EdgeState outgoingEdge : configuration.getOutgoingEdges()) {
                ComponentState targetComponent = outgoingEdge.getTargetComponent();
                DependencyMetadata dependencyMetadata = outgoingEdge.getDependencyMetadata();
                assert (dependencyMetadata instanceof LocalOriginDependencyMetadata);
                if (!((LocalOriginDependencyMetadata)dependencyMetadata).isForce() || !candidates.contains(targetComponent)) continue;
                targetComponent.addCause(VersionSelectionReasons.FORCED);
                details.select((ComponentResolutionState)Cast.uncheckedCast((Object)targetComponent));
                return;
            }
        }
    }
}

