/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.PreferJavaRuntimeVariant;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.CollectionUtils;

public class DefaultIvyModuleResolveMetadata
extends AbstractModuleComponentResolveMetadata
implements IvyModuleResolveMetadata {
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = PreferJavaRuntimeVariant.schema();
    private final ImmutableMap<String, Configuration> configurationDefinitions;
    private final ImmutableList<IvyDependencyDescriptor> dependencies;
    private final ImmutableList<Artifact> artifactDefinitions;
    private final ImmutableList<Exclude> excludes;
    private final ImmutableMap<NamespaceId, String> extraAttributes;
    private final String branch;
    private Map<Artifact, ModuleComponentArtifactMetadata> artifacts;

    DefaultIvyModuleResolveMetadata(DefaultMutableIvyModuleResolveMetadata metadata) {
        super(metadata);
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.branch = metadata.getBranch();
        this.artifactDefinitions = metadata.getArtifactDefinitions();
        this.dependencies = metadata.getDependencies();
        this.excludes = metadata.getExcludes();
        this.extraAttributes = metadata.getExtraAttributes();
    }

    private DefaultIvyModuleResolveMetadata(DefaultIvyModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.branch = metadata.branch;
        this.artifactDefinitions = metadata.artifactDefinitions;
        this.dependencies = metadata.dependencies;
        this.excludes = metadata.excludes;
        this.extraAttributes = metadata.extraAttributes;
        this.copyCachedState(metadata);
    }

    private DefaultIvyModuleResolveMetadata(DefaultIvyModuleResolveMetadata metadata, List<IvyDependencyDescriptor> dependencies) {
        super(metadata, metadata.getSource());
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.branch = metadata.branch;
        this.artifactDefinitions = metadata.artifactDefinitions;
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.excludes = metadata.excludes;
        this.extraAttributes = metadata.extraAttributes;
    }

    @Override
    protected DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<String> hierarchy, VariantMetadataRules componentMetadataRules) {
        ImmutableList<ModuleComponentArtifactMetadata> artifacts = this.filterArtifacts(name, hierarchy);
        ImmutableList<ExcludeMetadata> excludesForConfiguration = this.filterExcludes(hierarchy);
        DefaultConfigurationMetadata configuration = new DefaultConfigurationMetadata(componentId, name, transitive, visible, hierarchy, (ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.copyOf(artifacts), componentMetadataRules, excludesForConfiguration);
        configuration.setDependencies((List<ModuleDependencyMetadata>)this.filterDependencies(configuration));
        return configuration;
    }

    private ImmutableList<ModuleComponentArtifactMetadata> filterArtifacts(String name, ImmutableList<String> hierarchy) {
        LinkedHashSet<ModuleComponentArtifactMetadata> artifacts = new LinkedHashSet<ModuleComponentArtifactMetadata>();
        this.collectArtifactsFor(name, artifacts);
        for (String parent : hierarchy) {
            this.collectArtifactsFor(parent, artifacts);
        }
        return ImmutableList.copyOf(artifacts);
    }

    private void collectArtifactsFor(String name, Collection<ModuleComponentArtifactMetadata> dest) {
        if (this.artifacts == null) {
            this.artifacts = new IdentityHashMap<Artifact, ModuleComponentArtifactMetadata>();
        }
        for (Artifact artifact : this.artifactDefinitions) {
            if (!artifact.getConfigurations().contains(name)) continue;
            ModuleComponentArtifactMetadata artifactMetadata = this.artifacts.get(artifact);
            if (artifactMetadata == null) {
                artifactMetadata = new DefaultModuleComponentArtifactMetadata(this.getId(), artifact.getArtifactName());
                this.artifacts.put(artifact, artifactMetadata);
            }
            dest.add(artifactMetadata);
        }
    }

    private ImmutableList<ExcludeMetadata> filterExcludes(ImmutableList<String> hierarchy) {
        ImmutableList.Builder filtered = ImmutableList.builder();
        block0: for (Exclude exclude : this.excludes) {
            for (String config : exclude.getConfigurations()) {
                if (!hierarchy.contains((Object)config)) continue;
                filtered.add((Object)exclude);
                continue block0;
            }
        }
        return filtered.build();
    }

    private ImmutableList<ModuleDependencyMetadata> filterDependencies(DefaultConfigurationMetadata config) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        for (IvyDependencyDescriptor dependency : this.dependencies) {
            if (!this.include(dependency, config.getName(), config.getHierarchy())) continue;
            filteredDependencies.add((Object)this.contextualize(config, this.getId(), dependency));
        }
        return filteredDependencies.build();
    }

    private ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, IvyDependencyDescriptor incoming) {
        return new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
    }

    private boolean include(IvyDependencyDescriptor dependency, String configName, Collection<String> hierarchy) {
        Set dependencyConfigurations = dependency.getConfMappings().keySet();
        for (String moduleConfiguration : dependencyConfigurations) {
            if (moduleConfiguration.equals("%") || hierarchy.contains(moduleConfiguration)) {
                return true;
            }
            if (!moduleConfiguration.equals("*")) continue;
            boolean include = true;
            for (String conf2 : dependencyConfigurations) {
                if (!conf2.startsWith("!") || !conf2.substring(1).equals(configName)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            return true;
        }
        return false;
    }

    @Override
    public DefaultIvyModuleResolveMetadata withSource(ModuleSource source) {
        return new DefaultIvyModuleResolveMetadata(this, source);
    }

    @Override
    public MutableIvyModuleResolveMetadata asMutable() {
        return new DefaultMutableIvyModuleResolveMetadata(this);
    }

    @Override
    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    @Override
    public ImmutableList<Artifact> getArtifactDefinitions() {
        return this.artifactDefinitions;
    }

    @Override
    public ImmutableList<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public ImmutableMap<NamespaceId, String> getExtraAttributes() {
        return this.extraAttributes;
    }

    @Override
    public IvyModuleResolveMetadata withDynamicConstraintVersions() {
        List transformed = CollectionUtils.collect(this.getDependencies(), (Transformer)new Transformer<IvyDependencyDescriptor, IvyDependencyDescriptor>(){

            public IvyDependencyDescriptor transform(IvyDependencyDescriptor dependency) {
                ModuleComponentSelector selector = dependency.getSelector();
                String dynamicConstraintVersion = dependency.getDynamicConstraintVersion();
                ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getModule(), dynamicConstraintVersion);
                return dependency.withRequested(newSelector);
            }
        });
        return this.withDependencies(transformed);
    }

    private IvyModuleResolveMetadata withDependencies(List<IvyDependencyDescriptor> transformed) {
        return new DefaultIvyModuleResolveMetadata(this, transformed);
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    @Override
    public ImmutableList<IvyDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultIvyModuleResolveMetadata that = (DefaultIvyModuleResolveMetadata)o;
        return Objects.equal(this.dependencies, that.dependencies) && Objects.equal(this.artifactDefinitions, that.artifactDefinitions) && Objects.equal(this.excludes, that.excludes) && Objects.equal(this.extraAttributes, that.extraAttributes) && Objects.equal((Object)this.branch, (Object)that.branch) && Objects.equal(this.artifacts, that.artifacts);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.artifactDefinitions, this.excludes, this.extraAttributes, this.branch, this.artifacts});
    }
}

