/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.CoercingStringValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.PreferJavaRuntimeVariant;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;

public class DefaultMavenModuleResolveMetadata
extends AbstractModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    public static final String POM_PACKAGING = "pom";
    public static final Collection<String> JAR_PACKAGINGS = Arrays.asList("jar", "ejb", "bundle", "maven-plugin", "eclipse-plugin");
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = PreferJavaRuntimeVariant.schema();
    private static final Attribute<String> USAGE_ATTRIBUTE = Attribute.of((String)Usage.USAGE_ATTRIBUTE.getName(), String.class);
    private final boolean improvedPomSupportEnabled;
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator objectInstantiator;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private ImmutableList<? extends ConfigurationMetadata> derivedVariants;

    DefaultMavenModuleResolveMetadata(DefaultMutableMavenModuleResolveMetadata metadata, ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator objectInstantiator, boolean improvedPomSupportEnabled) {
        super(metadata);
        this.improvedPomSupportEnabled = improvedPomSupportEnabled;
        this.attributesFactory = attributesFactory;
        this.objectInstantiator = objectInstantiator;
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
    }

    private DefaultMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.improvedPomSupportEnabled = metadata.improvedPomSupportEnabled;
        this.attributesFactory = metadata.attributesFactory;
        this.objectInstantiator = metadata.objectInstantiator;
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.dependencies = metadata.dependencies;
        this.copyCachedState(metadata);
    }

    @Override
    protected DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<String> parents, VariantMetadataRules componentMetadataRules) {
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = this.getArtifactsForConfiguration(name);
        DefaultConfigurationMetadata configuration = new DefaultConfigurationMetadata(componentId, name, transitive, visible, parents, artifacts, componentMetadataRules, (ImmutableList<ExcludeMetadata>)ImmutableList.of());
        configuration.setDependencies((List<ModuleDependencyMetadata>)this.filterDependencies(configuration));
        return configuration;
    }

    @Override
    protected ImmutableList<? extends ConfigurationMetadata> maybeDeriveVariants() {
        return this.isJavaLibrary() ? this.getDerivedVariants() : ImmutableList.of();
    }

    private ImmutableList<? extends ConfigurationMetadata> getDerivedVariants() {
        if (this.derivedVariants == null) {
            this.derivedVariants = ImmutableList.of((Object)this.withUsageAttribute((DefaultConfigurationMetadata)this.getConfiguration("compile"), "java-api", this.attributesFactory), (Object)this.withUsageAttribute((DefaultConfigurationMetadata)this.getConfiguration("runtime"), "java-runtime", this.attributesFactory));
        }
        return this.derivedVariants;
    }

    private ConfigurationMetadata withUsageAttribute(DefaultConfigurationMetadata conf, String usage, ImmutableAttributesFactory attributesFactory) {
        return conf.withAttributes(attributesFactory.concat(ImmutableAttributes.EMPTY, USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot(usage, this.objectInstantiator)));
    }

    private ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactsForConfiguration(String name) {
        ImmutableList artifacts = name.equals("compile") || name.equals("runtime") || name.equals("default") || name.equals("test") ? ImmutableList.of((Object)new DefaultModuleComponentArtifactMetadata(this.getId(), new DefaultIvyArtifactName(this.getId().getModule(), "jar", "jar"))) : ImmutableList.of();
        return artifacts;
    }

    private ImmutableList<ModuleDependencyMetadata> filterDependencies(DefaultConfigurationMetadata config) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        boolean isOptionalConfiguration = "optional".equals(config.getName());
        for (MavenDependencyDescriptor dependency : this.dependencies) {
            if (isOptionalConfiguration && this.includeInOptionalConfiguration(dependency)) {
                filteredDependencies.add((Object)new OptionalConfigurationDependencyMetadata((ConfigurationMetadata)config, this.getId(), dependency));
                continue;
            }
            if (!this.include(dependency, config.getHierarchy())) continue;
            filteredDependencies.add((Object)this.contextualize(config, this.getId(), dependency));
        }
        return filteredDependencies.build();
    }

    private ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, MavenDependencyDescriptor incoming) {
        ConfigurationBoundExternalDependencyMetadata dependency = new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
        if (this.improvedPomSupportEnabled) {
            dependency.alwaysUseAttributeMatching();
        }
        return dependency;
    }

    private boolean includeInOptionalConfiguration(MavenDependencyDescriptor dependency) {
        MavenScope dependencyScope = dependency.getScope();
        return dependency.isOptional() && dependencyScope != MavenScope.Test && dependencyScope != MavenScope.System;
    }

    private boolean include(MavenDependencyDescriptor dependency, Collection<String> hierarchy) {
        MavenScope dependencyScope = dependency.getScope();
        if (dependency.isOptional() && this.ignoreOptionalDependencies()) {
            return false;
        }
        return hierarchy.contains(dependencyScope.name().toLowerCase());
    }

    private boolean ignoreOptionalDependencies() {
        return !this.improvedPomSupportEnabled;
    }

    @Override
    public DefaultMavenModuleResolveMetadata withSource(ModuleSource source) {
        return new DefaultMavenModuleResolveMetadata(this, source);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this, this.attributesFactory, this.objectInstantiator, this.improvedPomSupportEnabled);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return JAR_PACKAGINGS.contains(this.packaging);
    }

    private boolean isJavaLibrary() {
        return this.improvedPomSupportEnabled && (this.isKnownJarPackaging() || this.isPomPackaging());
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultMavenModuleResolveMetadata that = (DefaultMavenModuleResolveMetadata)o;
        return this.relocated == that.relocated && Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.snapshotTimestamp, (Object)that.snapshotTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.packaging, this.relocated, this.snapshotTimestamp});
    }

    private static class OptionalConfigurationDependencyMetadata
    extends ConfigurationBoundExternalDependencyMetadata {
        private final MavenDependencyDescriptor dependencyDescriptor;

        public OptionalConfigurationDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, MavenDependencyDescriptor delegate) {
            super(configuration, componentId, delegate);
            this.dependencyDescriptor = delegate;
        }

        @Override
        public List<IvyArtifactName> getArtifacts() {
            IvyArtifactName dependencyArtifact = this.dependencyDescriptor.getDependencyArtifact();
            return dependencyArtifact == null ? ImmutableList.of() : ImmutableList.of((Object)dependencyArtifact);
        }

        @Override
        public boolean isPending() {
            return false;
        }
    }
}

