/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import com.google.common.base.Optional;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.Delete;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.plugins.ide.IdeWorkspace;
import org.gradle.process.ExecSpec;

public abstract class IdePlugin
implements Plugin<Project> {
    private Task lifecycleTask;
    private Task cleanTask;
    protected Project project;

    public static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional gradleWrapperPath = Optional.absent();
        Project rootProject = project.getRootProject();
        String gradlewExtension = OperatingSystem.current().isWindows() ? ".bat" : "";
        File gradlewFile = rootProject.file((Object)("gradlew" + gradlewExtension));
        if (gradlewFile.exists()) {
            gradleWrapperPath = Optional.of((Object)gradlewFile.getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or((Object)"gradle");
    }

    public void apply(Project target) {
        this.project = target;
        String lifecycleTaskName = this.getLifecycleTaskName();
        this.lifecycleTask = target.task(lifecycleTaskName);
        this.lifecycleTask.setGroup("IDE");
        this.cleanTask = target.getTasks().create(this.cleanName(lifecycleTaskName), Delete.class);
        this.cleanTask.setGroup("IDE");
        this.onApply(target);
    }

    public Task getLifecycleTask() {
        return this.lifecycleTask;
    }

    public Task getCleanTask() {
        return this.cleanTask;
    }

    protected String cleanName(String taskName) {
        return String.format("clean%s", StringUtils.capitalize((String)taskName));
    }

    public void addWorker(Task worker) {
        this.addWorker(worker, true);
    }

    public void addWorker(Task worker, boolean includeInClean) {
        this.lifecycleTask.dependsOn(new Object[]{worker});
        Delete cleanWorker = (Delete)this.project.getTasks().create(this.cleanName(worker.getName()), Delete.class);
        cleanWorker.delete(new Object[]{worker.getOutputs().getFiles()});
        if (includeInClean) {
            this.cleanTask.dependsOn(new Object[]{cleanWorker});
        }
    }

    protected void onApply(Project target) {
    }

    protected void addWorkspace(final IdeWorkspace workspace) {
        this.lifecycleTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                System.out.println(String.format("Generated %s at %s", workspace.getDisplayName(), new ConsoleRenderer().asClickableFileUrl(((FileSystemLocation)workspace.getLocation().get()).getAsFile())));
            }
        });
        Task openTask = this.project.getTasks().create("open" + StringUtils.capitalize((String)this.getLifecycleTaskName()));
        openTask.dependsOn(new Object[]{this.lifecycleTask});
        openTask.setGroup("IDE");
        openTask.setDescription("Opens the " + workspace.getDisplayName());
        openTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                if (OperatingSystem.current().isMacOsX()) {
                    IdePlugin.this.project.exec((Action)new Action<ExecSpec>(){

                        public void execute(ExecSpec execSpec) {
                            execSpec.commandLine(new Object[]{"open", workspace.getLocation().get()});
                        }
                    });
                } else {
                    try {
                        Desktop.getDesktop().open(((FileSystemLocation)workspace.getLocation().get()).getAsFile());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
            }
        });
    }

    protected abstract String getLifecycleTaskName();

    public boolean isRoot() {
        return this.project.getParent() == null;
    }
}

