/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

public class StashDropCommand
extends GitCommand<ObjectId> {
    private int stashRefEntry;
    private boolean all;

    public StashDropCommand(Repository repo) {
        super(repo);
    }

    public StashDropCommand setStashRef(int stashRef) {
        if (stashRef < 0) {
            throw new IllegalArgumentException();
        }
        this.stashRefEntry = stashRef;
        return this;
    }

    public StashDropCommand setAll(boolean all) {
        this.all = all;
        return this;
    }

    private Ref getRef() throws GitAPIException {
        try {
            return this.repo.exactRef("refs/stash");
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
    }

    private RefUpdate createRefUpdate(Ref stashRef) throws IOException {
        RefUpdate update = this.repo.updateRef("refs/stash");
        update.disableRefLog();
        update.setExpectedOldObjectId(stashRef.getObjectId());
        update.setForceUpdate(true);
        return update;
    }

    private void deleteRef(Ref stashRef) {
        try {
            RefUpdate.Result result = this.createRefUpdate(stashRef).delete();
            if (RefUpdate.Result.FORCED != result) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().stashDropDeleteRefFailed, new Object[]{result}));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
    }

    private void updateRef(Ref stashRef, ObjectId newId) {
        try {
            RefUpdate update = this.createRefUpdate(stashRef);
            update.setNewObjectId(newId);
            RefUpdate.Result result = update.update();
            switch (result) {
                case FORCED: 
                case NEW: 
                case NO_CHANGE: {
                    return;
                }
            }
            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"refs/stash", newId, result}));
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
    }

    @Override
    public ObjectId call() throws GitAPIException {
        List<ReflogEntry> entries;
        this.checkCallable();
        Ref stashRef = this.getRef();
        if (stashRef == null) {
            return null;
        }
        if (this.all) {
            this.deleteRef(stashRef);
            return null;
        }
        try {
            ReflogReader reader = this.repo.getReflogReader("refs/stash");
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, stashRef));
            }
            entries = reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
        if (this.stashRefEntry >= entries.size()) {
            throw new JGitInternalException(JGitText.get().stashDropMissingReflog);
        }
        if (entries.size() == 1) {
            this.deleteRef(stashRef);
            return null;
        }
        ReflogWriter writer = new ReflogWriter(this.repo, true);
        String stashLockRef = ReflogWriter.refLockFor("refs/stash");
        File stashLockFile = writer.logFor(stashLockRef);
        File stashFile = writer.logFor("refs/stash");
        if (stashLockFile.exists()) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, new LockFailedException(stashFile));
        }
        entries.remove(this.stashRefEntry);
        ObjectId entryId = ObjectId.zeroId();
        try {
            for (int i = entries.size() - 1; i >= 0; --i) {
                ReflogEntry entry = entries.get(i);
                writer.log(stashLockRef, entryId, entry.getNewId(), entry.getWho(), entry.getComment());
                entryId = entry.getNewId();
            }
            try {
                FileUtils.rename(stashLockFile, stashFile, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameFileFailed, stashLockFile.getPath(), stashFile.getPath()), e);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
        this.updateRef(stashRef, entryId);
        try {
            Ref newStashRef = this.repo.exactRef("refs/stash");
            return newStashRef != null ? newStashRef.getObjectId() : null;
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
    }
}

