/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IvyPluginPublishingPlugin
implements Plugin<Project> {
    IvyPluginPublishingPlugin() {
    }

    public void apply(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                final GradlePluginDevelopmentExtension pluginDevelopment = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
                if (!pluginDevelopment.isAutomatedPublishing()) {
                    return;
                }
                project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                    public void execute(PublishingExtension publishing) {
                        SoftwareComponent mainComponent = (SoftwareComponent)project.getComponents().getByName("java");
                        IvyPublication mainPublication = IvyPluginPublishingPlugin.this.addMainPublication(publishing, mainComponent);
                        IvyPluginPublishingPlugin.this.addMarkerPublications(mainPublication, publishing, pluginDevelopment);
                    }
                });
            }
        });
    }

    private IvyPublication addMainPublication(PublishingExtension publishing, SoftwareComponent mainComponent) {
        IvyPublication publication = (IvyPublication)publishing.getPublications().maybeCreate("pluginIvy", IvyPublication.class);
        publication.from(mainComponent);
        return publication;
    }

    private void addMarkerPublications(IvyPublication mainPublication, PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment) {
        for (PluginDeclaration declaration : pluginDevelopment.getPlugins()) {
            this.createIvyMarkerPublication(declaration, mainPublication, publishing.getPublications());
        }
    }

    private void createIvyMarkerPublication(PluginDeclaration declaration, final IvyPublication mainPublication, PublicationContainer publications) {
        String pluginId = declaration.getId();
        IvyPublicationInternal publication = (IvyPublicationInternal)publications.create(declaration.getName() + "PluginMarkerIvy", IvyPublication.class);
        publication.setAlias(true);
        publication.setOrganisation(pluginId);
        publication.setModule(pluginId + ".gradle.plugin");
        publication.descriptor((Action)new Action<IvyModuleDescriptorSpec>(){

            public void execute(IvyModuleDescriptorSpec descriptor) {
                descriptor.withXml((Action)new Action<XmlProvider>(){

                    public void execute(XmlProvider xmlProvider) {
                        Element root = xmlProvider.asElement();
                        Document document = root.getOwnerDocument();
                        Node dependencies = root.getElementsByTagName("dependencies").item(0);
                        Node dependency = dependencies.appendChild(document.createElement("dependency"));
                        Attr org = document.createAttribute("org");
                        org.setValue(mainPublication.getOrganisation());
                        dependency.getAttributes().setNamedItem(org);
                        Attr name = document.createAttribute("name");
                        name.setValue(mainPublication.getModule());
                        dependency.getAttributes().setNamedItem(name);
                        Attr rev = document.createAttribute("rev");
                        rev.setValue(mainPublication.getRevision());
                        dependency.getAttributes().setNamedItem(rev);
                    }
                });
            }
        });
    }
}

