/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.TransformArtifactOperation;
import org.gradle.api.internal.artifacts.transform.TransformFileOperation;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

class ArtifactTransformingVisitor
implements ArtifactVisitor {
    private final ArtifactVisitor visitor;
    private final AttributeContainerInternal target;
    private final Map<ResolvableArtifact, TransformArtifactOperation> artifactResults;
    private final Map<File, TransformFileOperation> fileResults;

    ArtifactTransformingVisitor(ArtifactVisitor visitor, AttributeContainerInternal target, Map<ResolvableArtifact, TransformArtifactOperation> artifactResults, Map<File, TransformFileOperation> fileResults) {
        this.visitor = visitor;
        this.target = target;
        this.artifactResults = artifactResults;
        this.fileResults = fileResults;
    }

    @Override
    public void visitArtifact(String variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
        TransformArtifactOperation operation = this.artifactResults.get(artifact);
        if (operation.getFailure() != null) {
            this.visitor.visitFailure(operation.getFailure());
            return;
        }
        ResolvedArtifact sourceArtifact = artifact.toPublicView();
        List<File> transformedFiles = operation.getResult();
        TaskDependency buildDependencies = ((Buildable)artifact).getBuildDependencies();
        for (File output : transformedFiles) {
            DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forFile(output, sourceArtifact.getClassifier());
            ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(sourceArtifact.getId().getComponentIdentifier(), artifactName);
            DefaultResolvedArtifact resolvedArtifact = new DefaultResolvedArtifact(sourceArtifact.getModuleVersion().getId(), (IvyArtifactName)artifactName, (ComponentArtifactIdentifier)newId, buildDependencies, output);
            this.visitor.visitArtifact(variantName, (AttributeContainer)this.target, resolvedArtifact);
        }
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.visitor.visitFailure(failure);
    }

    @Override
    public boolean includeFiles() {
        return this.visitor.includeFiles();
    }

    @Override
    public boolean requireArtifactFiles() {
        return this.visitor.requireArtifactFiles();
    }

    @Override
    public void visitFile(ComponentArtifactIdentifier artifactIdentifier, String variantName, AttributeContainer variantAttributes, File file) {
        TransformFileOperation operation = this.fileResults.get(file);
        if (operation.getFailure() != null) {
            this.visitor.visitFailure(operation.getFailure());
            return;
        }
        List<File> result = operation.getResult();
        for (File outputFile : result) {
            this.visitor.visitFile(new ComponentFileArtifactIdentifier(artifactIdentifier.getComponentIdentifier(), outputFile.getName()), variantName, (AttributeContainer)this.target, outputFile);
        }
    }
}

