/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.vcs;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.specs.Spec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.util.CollectionUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.VcsResolver;
import org.gradle.vcs.internal.VcsWorkingDirectoryRoot;
import org.gradle.vcs.internal.VersionControlSystem;
import org.gradle.vcs.internal.VersionControlSystemFactory;
import org.gradle.vcs.internal.VersionRef;
import org.gradle.vcs.internal.spec.AbstractVersionControlSpec;

public class VcsDependencyResolver
implements DependencyToComponentIdResolver,
ComponentResolvers {
    private final ProjectDependencyResolver projectDependencyResolver;
    private final LocalComponentRegistry localComponentRegistry;
    private final VcsResolver vcsResolver;
    private final VersionControlSystemFactory versionControlSystemFactory;
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final BuildStateRegistry buildRegistry;
    private final NestedBuildFactory nestedBuildFactory;
    private final File baseWorkingDir;
    private final Map<String, VersionRef> selectedVersionCache = new HashMap<String, VersionRef>();
    private final VersionParser versionParser;

    public VcsDependencyResolver(VcsWorkingDirectoryRoot vcsWorkingDirRoot, ProjectDependencyResolver projectDependencyResolver, LocalComponentRegistry localComponentRegistry, VcsResolver vcsResolver, VersionControlSystemFactory versionControlSystemFactory, VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, BuildStateRegistry buildRegistry, NestedBuildFactory nestedBuildFactory, VersionParser versionParser) {
        this.baseWorkingDir = vcsWorkingDirRoot.getDir();
        this.projectDependencyResolver = projectDependencyResolver;
        this.localComponentRegistry = localComponentRegistry;
        this.vcsResolver = vcsResolver;
        this.versionControlSystemFactory = versionControlSystemFactory;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.buildRegistry = buildRegistry;
        this.nestedBuildFactory = nestedBuildFactory;
        this.versionParser = versionParser;
    }

    @Override
    public void resolve(DependencyMetadata dependency, ResolvedVersionConstraint versionConstraint, BuildableComponentIdResolveResult result) {
        ModuleComponentSelector depSelector;
        VersionControlSpec spec;
        if (dependency.getSelector() instanceof ModuleComponentSelector && (spec = this.vcsResolver.locateVcsFor(depSelector = (ModuleComponentSelector)dependency.getSelector())) != null) {
            VersionControlSystem versionControlSystem = this.versionControlSystemFactory.create(spec);
            VersionRef selectedVersion = this.selectVersion(depSelector, spec, versionControlSystem);
            if (selectedVersion == null) {
                result.failed(new ModuleVersionNotFoundException(depSelector, Collections.singleton(spec.getDisplayName())));
                return;
            }
            File dependencyWorkingDir = new File(this.populateWorkingDirectory(this.baseWorkingDir, spec, versionControlSystem, selectedVersion), spec.getRootDir());
            IncludedBuildState includedBuild = this.buildRegistry.addImplicitBuild(((AbstractVersionControlSpec)spec).getBuildDefinition(dependencyWorkingDir), this.nestedBuildFactory);
            Set moduleToProject = includedBuild.getAvailableModules();
            Pair entry = (Pair)CollectionUtils.findFirst((Iterable)moduleToProject, (Spec)new Spec<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>>(){

                public boolean isSatisfiedBy(Pair<ModuleVersionIdentifier, ProjectComponentIdentifier> entry) {
                    ModuleVersionIdentifier possibleMatch = (ModuleVersionIdentifier)entry.left;
                    return depSelector.getGroup().equals(possibleMatch.getGroup()) && depSelector.getModule().equals(possibleMatch.getName());
                }
            });
            if (entry == null) {
                result.failed(new ModuleVersionResolveException((ComponentSelector)depSelector, spec.getDisplayName() + " did not contain a project publishing the specified dependency."));
            } else {
                LocalComponentMetadata componentMetaData = this.localComponentRegistry.getComponent((ProjectComponentIdentifier)entry.right);
                if (componentMetaData == null) {
                    result.failed(new ModuleVersionResolveException((ComponentSelector)DefaultProjectComponentSelector.newSelector((ProjectComponentIdentifier)entry.right), spec.getDisplayName() + " could not be resolved into a usable project."));
                } else {
                    result.resolved(componentMetaData);
                }
                return;
            }
        }
        this.projectDependencyResolver.resolve(dependency, versionConstraint, result);
    }

    private VersionRef selectVersion(ModuleComponentSelector depSelector, VersionControlSpec spec, VersionControlSystem versionControlSystem) {
        String cacheKey = this.cacheKey(spec, depSelector.getVersionConstraint());
        if (this.selectedVersionCache.containsKey(cacheKey)) {
            return this.selectedVersionCache.get(cacheKey);
        }
        VersionRef selectedVersion = this.selectVersionFromRepository(spec, versionControlSystem, depSelector.getVersionConstraint());
        this.selectedVersionCache.put(cacheKey, selectedVersion);
        return selectedVersion;
    }

    private File populateWorkingDirectory(File baseWorkingDir, VersionControlSpec spec, VersionControlSystem versionControlSystem, VersionRef selectedVersion) {
        String repositoryId = HashUtil.createCompactMD5((String)spec.getUniqueId());
        File versionDirectory = new File(baseWorkingDir, repositoryId + "-" + selectedVersion.getCanonicalId());
        return versionControlSystem.populate(versionDirectory, selectedVersion, spec);
    }

    private VersionRef selectVersionFromRepository(VersionControlSpec spec, VersionControlSystem versionControlSystem, VersionConstraint constraint) {
        if (constraint.getBranch() != null) {
            return versionControlSystem.getBranch(spec, constraint.getBranch());
        }
        String version = constraint.getPreferredVersion();
        VersionSelector versionSelector = this.versionSelectorScheme.parseSelector(version);
        if (versionSelector instanceof LatestVersionSelector && ((LatestVersionSelector)versionSelector).getSelectorStatus().equals("integration")) {
            return versionControlSystem.getDefaultBranch(spec);
        }
        if (versionSelector.requiresMetadata()) {
            return null;
        }
        Set versions = versionControlSystem.getAvailableVersions(spec);
        Version bestVersion = null;
        VersionRef bestCandidate = null;
        for (VersionRef candidate : versions) {
            Version candidateVersion = this.versionParser.transform(candidate.getVersion());
            if (!versionSelector.accept(candidateVersion) || bestCandidate != null && this.versionComparator.asVersionComparator().compare(candidateVersion, bestVersion) <= 0) continue;
            bestVersion = candidateVersion;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    private String cacheKey(VersionControlSpec spec, VersionConstraint constraint) {
        if (constraint.getBranch() != null) {
            return spec.getUniqueId() + ":b:" + constraint.getBranch();
        }
        return spec.getUniqueId() + ":v:" + constraint.getPreferredVersion();
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this.projectDependencyResolver;
    }

    @Override
    public OriginArtifactSelector getArtifactSelector() {
        return this.projectDependencyResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.projectDependencyResolver;
    }
}

