/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskProperties;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskFailureCollector;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskInfoFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    private final Set<TaskInfo> tasksInUnknownState = new LinkedHashSet<TaskInfo>();
    private final Set<TaskInfo> entryTasks = new LinkedHashSet<TaskInfo>();
    private final LinkedHashMap<Task, TaskInfo> executionPlan = new LinkedHashMap();
    private final List<TaskInfo> executionQueue = new LinkedList<TaskInfo>();
    private final Map<Project, ResourceLock> projectLocks = Maps.newHashMap();
    private final TaskFailureCollector failureCollector = new TaskFailureCollector();
    private final TaskInfoFactory nodeFactory = new TaskInfoFactory(this.failureCollector);
    private Spec<? super Task> filter = Specs.satisfyAll();
    private boolean continueOnFailure;
    private final Set<TaskInfo> runningTasks = Sets.newIdentityHashSet();
    private final Set<Task> filteredTasks = Sets.newIdentityHashSet();
    private final Map<TaskInfo, TaskMutationInfo> taskMutations = Maps.newIdentityHashMap();
    private final Map<File, String> canonicalizedFileCache = Maps.newIdentityHashMap();
    private final Map<Pair<TaskInfo, TaskInfo>, Boolean> reachableCache = Maps.newHashMap();
    private final Set<TaskInfo> dependenciesCompleteCache = Sets.newHashSet();
    private final WorkerLeaseService workerLeaseService;
    private final GradleInternal gradle;
    private boolean tasksCancelled;

    public DefaultTaskExecutionPlan(WorkerLeaseService workerLeaseService, GradleInternal gradle) {
        this.workerLeaseService = workerLeaseService;
        this.gradle = gradle;
    }

    public String getDisplayName() {
        Path path = this.gradle.findIdentityPath();
        if (path == null) {
            return "gradle";
        }
        return path.toString();
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        TaskInfo node;
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>();
        ArrayList<? extends Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        for (Task task : sortedTasks) {
            node = this.nodeFactory.getOrCreateNode(task);
            if (node.isMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy((Object)task)) {
                node.require();
            }
            this.entryTasks.add(node);
            queue.add(node);
        }
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        CachingTaskDependencyResolveContext cachingTaskDependencyResolveContext = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            boolean filtered;
            node = (TaskInfo)queue.get(0);
            if (node.getDependenciesProcessed()) {
                queue.remove(0);
                continue;
            }
            TaskInternal task = node.getTask();
            boolean bl = filtered = !this.filter.isSatisfiedBy((Object)task);
            if (filtered) {
                queue.remove(0);
                node.dependenciesProcessed();
                node.doNotRequire();
                this.filteredTasks.add(task);
                continue;
            }
            if (visiting.add(node)) {
                TaskInfo targetNode;
                ((TaskContainerInternal)task.getProject().getTasks()).prepareForExecution(task);
                Set<? extends Task> dependsOnTasks = cachingTaskDependencyResolveContext.getDependencies(task, task.getTaskDependencies());
                for (Task task2 : dependsOnTasks) {
                    targetNode = this.nodeFactory.getOrCreateNode(task2);
                    node.addDependencySuccessor(targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task3 : cachingTaskDependencyResolveContext.getDependencies(task, task.getFinalizedBy())) {
                    targetNode = this.nodeFactory.getOrCreateNode(task3);
                    this.addFinalizerNode(node, targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task4 : cachingTaskDependencyResolveContext.getDependencies(task, task.getMustRunAfter())) {
                    targetNode = this.nodeFactory.getOrCreateNode(task4);
                    node.addMustSuccessor(targetNode);
                }
                for (Task task5 : cachingTaskDependencyResolveContext.getDependencies(task, task.getShouldRunAfter())) {
                    targetNode = this.nodeFactory.getOrCreateNode(task5);
                    node.addShouldSuccessor(targetNode);
                }
                if (node.isRequired()) {
                    for (TaskInfo taskInfo : node.getDependencySuccessors()) {
                        if (!this.filter.isSatisfiedBy((Object)taskInfo.getTask())) continue;
                        taskInfo.require();
                    }
                    continue;
                }
                this.tasksInUnknownState.add(node);
                continue;
            }
            queue.remove(0);
            visiting.remove(node);
            node.dependenciesProcessed();
        }
        this.resolveTasksInUnknownState();
    }

    private void resolveTasksInUnknownState() {
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>(this.tasksInUnknownState);
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        block0: while (!queue.isEmpty()) {
            TaskInfo task = (TaskInfo)queue.get(0);
            if (task.isInKnownState()) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                for (TaskInfo hardPredecessor : task.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.add(0, hardPredecessor);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            task.mustNotRun();
            for (TaskInfo predecessor : task.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.isMustNotRun());
                if (!predecessor.isRequired()) continue;
                task.require();
                continue block0;
            }
        }
    }

    private void addFinalizerNode(TaskInfo node, TaskInfo finalizerNode) {
        if (this.filter.isSatisfiedBy((Object)finalizerNode.getTask())) {
            node.addFinalizer(finalizerNode);
            if (!finalizerNode.isInKnownState()) {
                finalizerNode.mustNotRun();
            }
        }
    }

    private <T> void addAllReversed(List<T> list, TreeSet<T> set) {
        List elements = CollectionUtils.toList(set);
        Collections.reverse(elements);
        list.addAll(elements);
    }

    private void requireWithDependencies(TaskInfo taskInfo) {
        if (taskInfo.isMustNotRun() && this.filter.isSatisfiedBy((Object)taskInfo.getTask())) {
            taskInfo.require();
            for (TaskInfo dependency : taskInfo.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        ArrayList nodeQueue = Lists.newArrayList((Iterable)Iterables.transform(this.entryTasks, (Function)new Function<TaskInfo, TaskInfoInVisitingSegment>(){
            private int index;

            public TaskInfoInVisitingSegment apply(TaskInfo taskInfo) {
                return new TaskInfoInVisitingSegment(taskInfo, this.index++);
            }
        }));
        int visitingSegmentCounter = nodeQueue.size();
        HashMultimap visitingNodes = HashMultimap.create();
        ArrayDeque<GraphEdge> walkedShouldRunAfterEdges = new ArrayDeque<GraphEdge>();
        ArrayDeque<TaskInfo> path = new ArrayDeque<TaskInfo>();
        HashMap<TaskInfo, Integer> planBeforeVisiting = new HashMap<TaskInfo, Integer>();
        while (!nodeQueue.isEmpty()) {
            TaskInfoInVisitingSegment taskInfoInVisitingSegment = (TaskInfoInVisitingSegment)nodeQueue.get(0);
            int currentSegment = taskInfoInVisitingSegment.visitingSegment;
            TaskInfo taskNode = taskInfoInVisitingSegment.taskInfo;
            if (taskNode.isIncludeInGraph() || this.executionPlan.containsKey(taskNode.getTask())) {
                nodeQueue.remove(0);
                visitingNodes.remove((Object)taskNode, (Object)currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, taskNode);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey((Object)taskNode);
            visitingNodes.put((Object)taskNode, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, taskNode);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle((HashMultimap<TaskInfo, Integer>)visitingNodes, taskInfoInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, taskNode);
                ArrayList<TaskInfo> successors = new ArrayList<TaskInfo>();
                this.addAllSuccessorsInReverseOrder(taskNode, successors);
                for (TaskInfo successor : successors) {
                    if (visitingNodes.containsEntry((Object)successor, (Object)currentSegment)) {
                        if (!walkedShouldRunAfterEdges.isEmpty()) {
                            GraphEdge toBeRemoved = (GraphEdge)walkedShouldRunAfterEdges.pop();
                            toBeRemoved.from.removeShouldRunAfterSuccessor(toBeRemoved.to);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, (HashMultimap<TaskInfo, Integer>)visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle();
                    }
                    nodeQueue.add(0, new TaskInfoInVisitingSegment(successor, currentSegment));
                }
                path.push(taskNode);
                continue;
            }
            nodeQueue.remove(0);
            this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, taskNode);
            visitingNodes.remove((Object)taskNode, (Object)currentSegment);
            path.pop();
            this.executionPlan.put(taskNode.getTask(), taskNode);
            Project project = taskNode.getTask().getProject();
            this.projectLocks.put(project, this.getOrCreateProjectLock(project));
            TaskMutationInfo taskMutationInfo = this.getOrCreateMutationsOf(taskNode);
            for (TaskInfo dependency : taskNode.getDependencySuccessors()) {
                this.getOrCreateMutationsOf((TaskInfo)dependency).consumingTasks.add(taskNode);
                taskMutationInfo.consumesOutputOf.add(dependency);
            }
            ArrayList finalizerTasks = new ArrayList();
            this.addAllReversed(finalizerTasks, taskNode.getFinalizers());
            for (TaskInfo finalizer : finalizerTasks) {
                if (visitingNodes.containsKey((Object)finalizer)) continue;
                nodeQueue.add(this.finalizerTaskPosition(finalizer, nodeQueue), new TaskInfoInVisitingSegment(finalizer, visitingSegmentCounter++));
            }
        }
        this.executionQueue.clear();
        this.executionQueue.addAll(this.executionPlan.values());
    }

    @Override
    public Set<Task> getDependencies(Task task) {
        TaskInfo node = this.executionPlan.get(task);
        if (node == null) {
            throw new IllegalStateException("Task is not part of the execution plan, no dependency information is available.");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TaskInfo taskInfo : node.getDependencySuccessors()) {
            builder.add((Object)taskInfo.getTask());
        }
        return builder.build();
    }

    private TaskMutationInfo getOrCreateMutationsOf(TaskInfo taskInfo) {
        TaskMutationInfo mutations = this.taskMutations.get(taskInfo);
        if (mutations == null) {
            mutations = new TaskMutationInfo(taskInfo);
            this.taskMutations.put(taskInfo, mutations);
        }
        return mutations;
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Deque<GraphEdge> walkedShouldRunAfterEdges, TaskInfo taskNode) {
        if (!walkedShouldRunAfterEdges.isEmpty() && walkedShouldRunAfterEdges.peek().to.equals(taskNode)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(HashMap<TaskInfo, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        Iterator<Map.Entry<Task, TaskInfo>> executionPlanIterator = this.executionPlan.entrySet().iterator();
        for (int i = 0; i < planBeforeVisiting.get(toBeRemoved.from); ++i) {
            executionPlanIterator.next();
        }
        while (executionPlanIterator.hasNext()) {
            executionPlanIterator.next();
            executionPlanIterator.remove();
        }
    }

    private void restoreQueue(List<TaskInfoInVisitingSegment> nodeQueue, HashMultimap<TaskInfo, Integer> visitingNodes, GraphEdge toBeRemoved) {
        TaskInfoInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.taskInfo)) {
            nextInQueue = nodeQueue.get(0);
            visitingNodes.remove((Object)nextInQueue.taskInfo, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.taskInfo)) continue;
            nodeQueue.remove(0);
        }
    }

    private void restorePath(Deque<TaskInfo> path, GraphEdge toBeRemoved) {
        TaskInfo removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void addAllSuccessorsInReverseOrder(TaskInfo taskNode, ArrayList<TaskInfo> dependsOnTasks) {
        this.addAllReversed(dependsOnTasks, taskNode.getDependencySuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getMustSuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getFinalizingSuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getShouldSuccessors());
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(final HashMultimap<TaskInfo, Integer> visitingNodes, final TaskInfoInVisitingSegment taskNodeWithVisitingSegment) {
        TaskInfo taskNode = taskNodeWithVisitingSegment.taskInfo;
        Iterables.removeIf(taskNode.getShouldSuccessors(), (Predicate)new Predicate<TaskInfo>(){

            public boolean apply(TaskInfo input) {
                return visitingNodes.containsEntry((Object)input, (Object)taskNodeWithVisitingSegment.visitingSegment);
            }
        });
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(HashMap<TaskInfo, Integer> planBeforeVisiting, TaskInfo taskNode) {
        if (taskNode.getShouldSuccessors().size() > 0) {
            planBeforeVisiting.put(taskNode, this.executionPlan.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Deque<GraphEdge> walkedShouldRunAfterEdges, Deque<TaskInfo> path, TaskInfo taskNode) {
        if (!path.isEmpty() && path.peek().getShouldSuccessors().contains(taskNode)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(path.peek(), taskNode));
        }
    }

    private int finalizerTaskPosition(TaskInfo finalizer, final List<TaskInfoInVisitingSegment> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        Set<TaskInfo> precedingTasks = this.getAllPrecedingTasks(finalizer);
        Set precedingTaskIndices = CollectionUtils.collect(precedingTasks, (Transformer)new Transformer<Integer, TaskInfo>(){

            public Integer transform(final TaskInfo dependsOnTask) {
                return Iterables.indexOf((Iterable)nodeQueue, (Predicate)new Predicate<TaskInfoInVisitingSegment>(){

                    public boolean apply(TaskInfoInVisitingSegment taskInfoInVisitingSegment) {
                        return taskInfoInVisitingSegment.taskInfo.equals(dependsOnTask);
                    }
                });
            }
        });
        return (Integer)Collections.max(precedingTaskIndices) + 1;
    }

    private Set<TaskInfo> getAllPrecedingTasks(TaskInfo finalizer) {
        HashSet<TaskInfo> precedingTasks = new HashSet<TaskInfo>();
        ArrayDeque<TaskInfo> candidateTasks = new ArrayDeque<TaskInfo>();
        candidateTasks.addAll(finalizer.getDependencySuccessors());
        candidateTasks.addAll(finalizer.getMustSuccessors());
        candidateTasks.addAll(finalizer.getFinalizingSuccessors());
        candidateTasks.addAll(finalizer.getShouldSuccessors());
        while (!candidateTasks.isEmpty()) {
            TaskInfo precedingTask = (TaskInfo)candidateTasks.pop();
            if (!precedingTasks.add(precedingTask)) continue;
            candidateTasks.addAll(precedingTask.getMustSuccessors());
            candidateTasks.addAll(precedingTask.getFinalizingSuccessors());
        }
        return precedingTasks;
    }

    private void onOrderingCycle() {
        CachingDirectedGraphWalker<TaskInfo, Void> graphWalker = new CachingDirectedGraphWalker<TaskInfo, Void>(new DirectedGraph<TaskInfo, Void>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Void> values, Collection<? super TaskInfo> connectedNodes) {
                connectedNodes.addAll(node.getDependencySuccessors());
                connectedNodes.addAll(node.getMustSuccessors());
                connectedNodes.addAll(node.getFinalizingSuccessors());
            }
        });
        graphWalker.add((Iterable<TaskInfo>)this.entryTasks);
        final ArrayList firstCycle = new ArrayList(graphWalker.findCycles().get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<TaskInfo> graphRenderer = new DirectedGraphRenderer<TaskInfo>(new GraphNodeRenderer<TaskInfo>(){

            @Override
            public void renderTo(TaskInfo node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text((Object)node.getTask().getIdentityPath());
            }
        }, new DirectedGraph<TaskInfo, Object>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Object> values, Collection<? super TaskInfo> connectedNodes) {
                for (TaskInfo dependency : firstCycle) {
                    if (!node.getDependencySuccessors().contains(dependency) && !node.getMustSuccessors().contains(dependency) && !node.getFinalizingSuccessors().contains(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((TaskInfo)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    public void clear() {
        this.nodeFactory.clear();
        this.entryTasks.clear();
        this.executionPlan.clear();
        this.executionQueue.clear();
        this.projectLocks.clear();
        this.failureCollector.clearFailures();
        this.taskMutations.clear();
        this.canonicalizedFileCache.clear();
        this.reachableCache.clear();
        this.dependenciesCompleteCache.clear();
        this.runningTasks.clear();
    }

    @Override
    public Set<Task> getTasks() {
        return this.executionPlan.keySet();
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.filteredTasks;
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void setContinueOnFailure(boolean continueOnFailre) {
        this.continueOnFailure = continueOnFailre;
    }

    @Override
    @Nullable
    public TaskInfo selectNextTask(WorkerLeaseRegistry.WorkerLease workerLease, ResourceLockState resourceLockState) {
        if (this.allProjectsLocked()) {
            return null;
        }
        Iterator<TaskInfo> iterator = this.executionQueue.iterator();
        while (iterator.hasNext()) {
            TaskInfo taskInfo = iterator.next();
            if (!taskInfo.isReady() || !this.allDependenciesComplete(taskInfo)) continue;
            ResourceLock projectLock = this.getProjectLock(taskInfo);
            TaskMutationInfo taskMutationInfo = this.getResolvedTaskMutationInfo(taskInfo);
            if (!(projectLock.tryLock() && workerLease.tryLock() && this.canRunWithCurrentlyExecutedTasks(taskInfo, taskMutationInfo))) {
                resourceLockState.releaseLocks();
                continue;
            }
            if (taskInfo.allDependenciesSuccessful()) {
                this.recordTaskStarted(taskInfo);
                taskInfo.startExecution();
            } else {
                taskInfo.skipExecution();
            }
            iterator.remove();
            return taskInfo;
        }
        return null;
    }

    private TaskMutationInfo getResolvedTaskMutationInfo(TaskInfo taskInfo) {
        TaskInternal task = taskInfo.getTask();
        TaskMutationInfo taskMutationInfo = this.taskMutations.get(taskInfo);
        if (!taskMutationInfo.resolved) {
            ProjectInternal project = (ProjectInternal)task.getProject();
            ServiceRegistry serviceRegistry = project.getServices();
            PathToFileResolver resolver = (PathToFileResolver)serviceRegistry.get(PathToFileResolver.class);
            PropertyWalker propertyWalker = (PropertyWalker)serviceRegistry.get(PropertyWalker.class);
            TaskProperties taskProperties = DefaultTaskProperties.resolve(propertyWalker, resolver, task);
            taskMutationInfo.outputPaths.addAll(DefaultTaskExecutionPlan.getOutputPaths(this.canonicalizedFileCache, taskInfo, taskProperties.getOutputFiles(), taskProperties.getLocalStateFiles()));
            taskMutationInfo.destroyablePaths.addAll(DefaultTaskExecutionPlan.getDestroyablePaths(this.canonicalizedFileCache, taskInfo, taskProperties.getDestroyableFiles()));
            taskMutationInfo.hasFileInputs = !taskProperties.getInputFileProperties().isEmpty();
            taskMutationInfo.hasOutputs = taskProperties.hasDeclaredOutputs();
            taskMutationInfo.hasLocalState = !taskProperties.getLocalStateFiles().isEmpty();
            taskMutationInfo.resolved = true;
            if (!taskMutationInfo.destroyablePaths.isEmpty()) {
                if (taskMutationInfo.hasOutputs) {
                    throw new IllegalStateException("Task " + taskInfo.getTask().getIdentityPath() + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
                }
                if (taskMutationInfo.hasFileInputs) {
                    throw new IllegalStateException("Task " + taskInfo.getTask().getIdentityPath() + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
                }
                if (taskMutationInfo.hasLocalState) {
                    throw new IllegalStateException("Task " + taskInfo.getTask().getIdentityPath() + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
                }
            }
        }
        return taskMutationInfo;
    }

    private boolean allDependenciesComplete(TaskInfo taskInfo) {
        if (this.dependenciesCompleteCache.contains(taskInfo)) {
            return true;
        }
        boolean dependenciesComplete = taskInfo.allDependenciesComplete();
        if (dependenciesComplete) {
            this.dependenciesCompleteCache.add(taskInfo);
        }
        return dependenciesComplete;
    }

    private boolean allProjectsLocked() {
        for (ResourceLock lock : this.projectLocks.values()) {
            if (lock.isLocked()) continue;
            return false;
        }
        return true;
    }

    private ResourceLock getProjectLock(TaskInfo taskInfo) {
        return this.projectLocks.get(taskInfo.getTask().getProject());
    }

    private ResourceLock getOrCreateProjectLock(Project project) {
        String gradlePath = ((GradleInternal)project.getGradle()).getIdentityPath().toString();
        String projectPath = ((ProjectInternal)project).getIdentityPath().toString();
        return this.workerLeaseService.getProjectLock(gradlePath, projectPath);
    }

    private boolean canRunWithCurrentlyExecutedTasks(TaskInfo taskInfo, TaskMutationInfo taskMutationInfo) {
        Set<String> candidateTaskDestroyables = taskMutationInfo.destroyablePaths;
        if (!this.runningTasks.isEmpty()) {
            Set<String> candidateTaskMutations;
            Set<String> candidateTaskOutputs = taskMutationInfo.outputPaths;
            Set<String> set = candidateTaskMutations = !candidateTaskOutputs.isEmpty() ? candidateTaskOutputs : candidateTaskDestroyables;
            if (this.hasTaskWithOverlappingMutations(candidateTaskMutations)) {
                return false;
            }
        }
        return !this.doesDestroyNotYetConsumedOutputOfAnotherTask(taskInfo, candidateTaskDestroyables);
    }

    private static ImmutableSet<String> canonicalizedPaths(Map<File, String> cache, Iterable<File> files) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File file : files) {
            try {
                String path = cache.get(file);
                if (path == null) {
                    path = file.getCanonicalPath();
                    cache.put(file, path);
                }
                builder.add((Object)path);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        return builder.build();
    }

    private boolean hasTaskWithOverlappingMutations(Set<String> candidateTaskMutations) {
        if (!candidateTaskMutations.isEmpty()) {
            for (TaskInfo runningTask : this.runningTasks) {
                TaskMutationInfo taskMutationInfo = this.taskMutations.get(runningTask);
                Iterable runningTaskMutations = Iterables.concat(taskMutationInfo.outputPaths, taskMutationInfo.destroyablePaths);
                if (!DefaultTaskExecutionPlan.hasOverlap(candidateTaskMutations, runningTaskMutations)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesDestroyNotYetConsumedOutputOfAnotherTask(TaskInfo destroyerTask, Set<String> destroyablePaths) {
        if (!destroyablePaths.isEmpty()) {
            for (TaskMutationInfo producingTask : this.taskMutations.values()) {
                if (!producingTask.task.isComplete() || producingTask.consumingTasks.isEmpty() || !DefaultTaskExecutionPlan.hasOverlap(destroyablePaths, producingTask.outputPaths)) continue;
                for (TaskInfo consumingTask : producingTask.consumingTasks) {
                    if (this.doesConsumerDependOnDestroyer(consumingTask, destroyerTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean doesConsumerDependOnDestroyer(TaskInfo consumingTask, TaskInfo destroyerTask) {
        if (consumingTask == destroyerTask) {
            return true;
        }
        Pair taskPair = Pair.of((Object)consumingTask, (Object)destroyerTask);
        if (this.reachableCache.get(taskPair) != null) {
            return this.reachableCache.get(taskPair);
        }
        boolean reachable = false;
        for (TaskInfo dependency : Iterables.concat(consumingTask.getMustSuccessors(), consumingTask.getFinalizingSuccessors(), consumingTask.getDependencySuccessors())) {
            if (dependency.isComplete() || !this.doesConsumerDependOnDestroyer(dependency, destroyerTask)) continue;
            reachable = true;
        }
        this.reachableCache.put((Pair<TaskInfo, TaskInfo>)taskPair, reachable);
        return reachable;
    }

    private static boolean hasOverlap(Iterable<String> paths1, Iterable<String> paths2) {
        for (String path1 : paths1) {
            for (String path2 : paths2) {
                String overLappedPath = DefaultTaskExecutionPlan.getOverLappedPath(path1, path2);
                if (overLappedPath == null) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<String> getOutputPaths(Map<File, String> canonicalizedFileCache, TaskInfo task, FileCollection outputFiles, FileCollection localStateFiles) {
        try {
            return DefaultTaskExecutionPlan.canonicalizedPaths(canonicalizedFileCache, Iterables.concat((Iterable)outputFiles, (Iterable)localStateFiles));
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(DefaultTaskExecutionPlan.deadlockMessage(task, "an output or local state", "outputs"), e);
        }
    }

    private static Set<String> getDestroyablePaths(Map<File, String> canonicalizedFileCache, TaskInfo task, FileCollection destroyableFiles) {
        try {
            return DefaultTaskExecutionPlan.canonicalizedPaths(canonicalizedFileCache, (Iterable<File>)destroyableFiles);
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(DefaultTaskExecutionPlan.deadlockMessage(task, "a destroyable", "destroyables"), e);
        }
    }

    private static String deadlockMessage(TaskInfo task, String singular, String plural) {
        return String.format("A deadlock was detected while resolving the %s for task '%s'. This can be caused, for instance, by %s property causing dependency resolution.", plural, task, singular);
    }

    @Nullable
    private static String getOverLappedPath(String firstPath, String secondPath) {
        boolean isOverlapping;
        String longer;
        String shorter;
        if (firstPath.equals(secondPath)) {
            return firstPath;
        }
        if (firstPath.length() == secondPath.length()) {
            return null;
        }
        if (firstPath.length() > secondPath.length()) {
            shorter = secondPath;
            longer = firstPath;
        } else {
            shorter = firstPath;
            longer = secondPath;
        }
        boolean bl = isOverlapping = longer.startsWith(shorter) && longer.charAt(shorter.length()) == File.separatorChar;
        if (isOverlapping) {
            return shorter;
        }
        return null;
    }

    private void recordTaskStarted(TaskInfo taskInfo) {
        this.runningTasks.add(taskInfo);
    }

    private void recordTaskCompleted(TaskInfo taskInfo) {
        this.runningTasks.remove(taskInfo);
        TaskMutationInfo taskMutationInfo = this.taskMutations.get(taskInfo);
        for (TaskInfo producerTask : taskMutationInfo.consumesOutputOf) {
            TaskMutationInfo producerTaskMutationInfo = this.taskMutations.get(producerTask);
            if (!producerTaskMutationInfo.consumingTasks.remove(taskInfo) || !DefaultTaskExecutionPlan.canRemoveTaskMutation(producerTaskMutationInfo)) continue;
            this.taskMutations.remove(producerTask);
        }
        if (DefaultTaskExecutionPlan.canRemoveTaskMutation(taskMutationInfo)) {
            this.taskMutations.remove(taskInfo);
        }
    }

    private static boolean canRemoveTaskMutation(@Nullable TaskMutationInfo taskMutationInfo) {
        return taskMutationInfo != null && taskMutationInfo.task.isComplete() && taskMutationInfo.consumingTasks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskComplete(TaskInfo taskInfo) {
        try {
            if (!taskInfo.isComplete()) {
                DefaultTaskExecutionPlan.enforceFinalizerTasks(taskInfo);
                if (taskInfo.isFailed()) {
                    this.handleFailure(taskInfo);
                }
                taskInfo.finishExecution();
                this.recordTaskCompleted(taskInfo);
            }
        }
        finally {
            this.getProjectLock(taskInfo).unlock();
        }
    }

    private static void enforceFinalizerTasks(TaskInfo taskInfo) {
        for (TaskInfo finalizerNode : taskInfo.getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.isMustNotRun()) continue;
            DefaultTaskExecutionPlan.enforceWithDependencies(finalizerNode, Sets.newHashSet());
        }
    }

    private static void enforceWithDependencies(TaskInfo nodeInfo, Set<TaskInfo> enforcedTasks) {
        ArrayDeque<TaskInfo> candidateNodes = new ArrayDeque<TaskInfo>();
        candidateNodes.add(nodeInfo);
        while (!candidateNodes.isEmpty()) {
            TaskInfo node = (TaskInfo)candidateNodes.pop();
            if (enforcedTasks.contains(node)) continue;
            enforcedTasks.add(node);
            candidateNodes.addAll(node.getDependencySuccessors());
            if (!node.isMustNotRun() && !node.isRequired()) continue;
            node.enforceRun();
        }
    }

    @Override
    public void abortAllAndFail(Throwable t) {
        this.abortExecution(true);
        this.failureCollector.addFailure(t);
    }

    private void handleFailure(TaskInfo taskInfo) {
        Throwable executionFailure = taskInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failureCollector.addFailure(executionFailure);
            return;
        }
        try {
            if (!this.continueOnFailure) {
                taskInfo.getTask().getState().rethrowFailure();
            }
            this.failureCollector.addFailure(taskInfo.getTaskFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failureCollector.addFailure(e);
        }
    }

    private boolean abortExecution() {
        return this.abortExecution(false);
    }

    @Override
    public void cancelExecution() {
        this.tasksCancelled = this.abortExecution() || this.tasksCancelled;
    }

    private boolean abortExecution(boolean abortAll) {
        boolean aborted = false;
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isRequired()) {
                taskInfo.skipExecution();
                aborted = true;
            }
            if (!abortAll || !taskInfo.isReady()) continue;
            taskInfo.abortExecution();
            aborted = true;
        }
        return aborted;
    }

    @Override
    public void rethrowFailures() {
        if (this.tasksCancelled) {
            this.failureCollector.addFailure((Throwable)new BuildCancelledException());
        }
        if (this.failureCollector.getFailures().isEmpty()) {
            return;
        }
        if (this.failureCollector.getFailures().size() > 1) {
            throw new MultipleBuildFailures(this.failureCollector.getFailures());
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)this.failureCollector.getFailures().get(0));
    }

    @Override
    public boolean allTasksComplete() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasWorkRemaining() {
        for (TaskInfo taskInfo : this.executionQueue) {
            if (taskInfo.isComplete()) continue;
            return true;
        }
        return false;
    }

    private static class TaskMutationInfo {
        final TaskInfo task;
        final Set<TaskInfo> consumingTasks = Sets.newHashSet();
        final Set<TaskInfo> consumesOutputOf = Sets.newHashSet();
        final Set<String> outputPaths = Sets.newHashSet();
        final Set<String> destroyablePaths = Sets.newHashSet();
        boolean hasFileInputs;
        boolean hasOutputs;
        boolean hasLocalState;
        boolean resolved;

        TaskMutationInfo(TaskInfo task) {
            this.task = task;
        }
    }

    private static class TaskInfoInVisitingSegment {
        private final TaskInfo taskInfo;
        private final int visitingSegment;

        private TaskInfoInVisitingSegment(TaskInfo taskInfo, int visitingSegment) {
            this.taskInfo = taskInfo;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final TaskInfo from;
        private final TaskInfo to;

        private GraphEdge(TaskInfo from, TaskInfo to) {
            this.from = from;
            this.to = to;
        }
    }
}

