/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

class IncrementalCompilationInitializer {
    private final FileOperations fileOperations;
    private final FileTree sourceTree;

    public IncrementalCompilationInitializer(FileOperations fileOperations, FileTree sourceTree) {
        this.fileOperations = fileOperations;
        this.sourceTree = sourceTree;
    }

    public void initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable)ImmutableSet.of());
            spec.setClasses(Collections.<String>emptySet());
            return;
        }
        Factory patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = (PatternSet)patternSetFactory.create();
        PatternSet sourceToCompile = (PatternSet)patternSetFactory.create();
        this.preparePatterns(recompilationSpec.getClassesToCompile(), classesToDelete, sourceToCompile);
        spec.setSourceFiles(this.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
        this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory());
    }

    private Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching((PatternFilterable)sourceToCompile);
    }

    private void includePreviousCompilationOutputOnClasspath(JavaCompileSpec spec) {
        ArrayList classpath = Lists.newArrayList((Iterable)spec.getCompileClasspath());
        File destinationDir = spec.getDestinationDir();
        classpath.add(destinationDir);
        spec.setCompileClasspath(classpath);
    }

    @VisibleForTesting
    void addClassesToProcess(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        HashSet classesToProcess = Sets.newHashSet(recompilationSpec.getClassesToProcess());
        classesToProcess.removeAll(recompilationSpec.getClassesToCompile());
        spec.setClasses(classesToProcess);
    }

    private void deleteStaleFilesIn(PatternSet classesToDelete, File destinationDir) {
        if (destinationDir == null) {
            return;
        }
        FileTree deleteMe = this.fileOperations.fileTree((Object)destinationDir).matching((PatternFilterable)classesToDelete);
        this.fileOperations.delete(new Object[]{deleteMe});
    }

    @VisibleForTesting
    void preparePatterns(Collection<String> staleClasses, PatternSet filesToDelete, PatternSet sourceToCompile) {
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            filesToDelete.include(new String[]{path.concat(".class")});
            filesToDelete.include(new String[]{path.concat(".java")});
            filesToDelete.include(new String[]{path.concat("$*.class")});
            filesToDelete.include(new String[]{path.concat("$*.java")});
            sourceToCompile.include(new String[]{path.concat(".java")});
            sourceToCompile.include(new String[]{path.concat("$*.java")});
        }
    }
}

