/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.language.base.internal.plugins.CleanRule;

@Incubating
public class LifecycleBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_GROUP = "build";
    public static final String VERIFICATION_GROUP = "verification";

    public void apply(ProjectInternal project) {
        this.addClean(project);
        this.addCleanRule((Project)project);
        this.addAssemble(project);
        this.addCheck(project);
        this.addBuild(project);
    }

    private void addClean(final ProjectInternal project) {
        final Callable<File> buildDir = new Callable<File>(){

            @Override
            public File call() {
                return project.getBuildDir();
            }
        };
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)project.getServices().get(BuildOutputCleanupRegistry.class);
        buildOutputCleanupRegistry.registerOutputs((Object)buildDir);
        TaskProvider clean = project.getTasks().createLater(CLEAN_TASK_NAME, Delete.class, (Action)new Action<Delete>(){

            public void execute(Delete cleanTask) {
                cleanTask.setDescription("Deletes the build directory.");
                cleanTask.setGroup("build");
                cleanTask.delete(new Object[]{buildDir});
            }
        });
        buildOutputCleanupRegistry.registerOutputs((Object)new Callable<FileCollection>((Provider)clean){
            final /* synthetic */ Provider val$clean;
            {
                this.val$clean = provider;
            }

            @Override
            public FileCollection call() {
                return ((Delete)this.val$clean.get()).getTargetFiles();
            }
        });
    }

    private void addCleanRule(Project project) {
        project.getTasks().addRule((Rule)new CleanRule(project.getTasks()));
    }

    private void addAssemble(ProjectInternal project) {
        project.getTasks().createLater(ASSEMBLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task assembleTask) {
                assembleTask.setDescription("Assembles the outputs of this project.");
                assembleTask.setGroup("build");
            }
        });
    }

    private void addCheck(ProjectInternal project) {
        project.getTasks().createLater(CHECK_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task checkTask) {
                checkTask.setDescription("Runs all checks.");
                checkTask.setGroup(LifecycleBasePlugin.VERIFICATION_GROUP);
            }
        });
    }

    private void addBuild(ProjectInternal project) {
        project.getTasks().createLater("build", (Action)new Action<Task>(){

            public void execute(Task buildTask) {
                buildTask.setDescription("Assembles and tests this project.");
                buildTask.setGroup("build");
                buildTask.dependsOn(new Object[]{LifecycleBasePlugin.ASSEMBLE_TASK_NAME});
                buildTask.dependsOn(new Object[]{LifecycleBasePlugin.CHECK_TASK_NAME});
            }
        });
    }
}

