/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;

public class ModifierListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.ModifierListElement");
    private static final HashMap<String, Integer> ourModifierToOrderMap = new HashMap();

    public ModifierListElement() {
        super(JavaElementType.MODIFIER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor2, Boolean before) {
        if (before == null && first2 == last2 && ElementType.KEYWORD_BIT_SET.contains(first2.getElementType())) {
            anchor2 = ModifierListElement.getDefaultAnchor((PsiModifierList)SourceTreeToPsiMap.treeElementToPsi(this), (PsiKeyword)SourceTreeToPsiMap.treeElementToPsi(first2));
            before = Boolean.TRUE;
        }
        return super.addInternal(first2, last2, anchor2, before);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (child.getElementType() == JavaElementType.ANNOTATION) {
            return 250;
        }
        return 0;
    }

    @Nullable
    private static ASTNode getDefaultAnchor(PsiModifierList modifierList, PsiKeyword modifier) {
        Integer order = (Integer)ourModifierToOrderMap.get(modifier.getText());
        if (order == null) {
            return null;
        }
        for (ASTNode child = SourceTreeToPsiMap.psiToTreeNotNull(modifierList).getFirstChildNode(); child != null; child = child.getTreeNext()) {
            Integer order1;
            if (!ElementType.KEYWORD_BIT_SET.contains(child.getElementType()) || (order1 = (Integer)ourModifierToOrderMap.get(child.getText())) == null || order1 <= order) continue;
            return child;
        }
        return null;
    }

    static {
        ourModifierToOrderMap.put("public", 1);
        ourModifierToOrderMap.put("private", 1);
        ourModifierToOrderMap.put("protected", 1);
        ourModifierToOrderMap.put("static", 2);
        ourModifierToOrderMap.put("abstract", 2);
        ourModifierToOrderMap.put("final", 3);
        ourModifierToOrderMap.put("synchronized", 4);
        ourModifierToOrderMap.put("transient", 4);
        ourModifierToOrderMap.put("volatile", 4);
        ourModifierToOrderMap.put("native", 5);
        ourModifierToOrderMap.put("strictfp", 6);
    }
}

