/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue;
    private final HardKey myHardKeyInstance;
    @NotNull
    private final TObjectHashingStrategy<K> myStrategy;
    private Set<Map.Entry<K, V>> entrySet;
    private boolean processingQueue;

    RefHashMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            RefHashMap.$$$reportNull$$$0(0);
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.myHardKeyInstance = new HardKey();
        this.myStrategy = strategy;
        this.myMap = new MyMap(initialCapacity, loadFactor);
    }

    RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ContainerUtil.canonicalStrategy());
    }

    RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    RefHashMap() {
        this(4);
    }

    static <K> boolean keyEqual(K k1, K k2, TObjectHashingStrategy<K> strategy) {
        return k1 == k2 || strategy.equals(k1, k2);
    }

    @NotNull
    protected abstract <T> Key<T> createKey(@NotNull T var1, @NotNull TObjectHashingStrategy<T> var2, @NotNull ReferenceQueue<? super T> var3);

    boolean processQueue() {
        boolean processed = false;
        try {
            Key wk;
            this.processingQueue = true;
            while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
                this.removeKey(wk);
                processed = true;
            }
        }
        finally {
            this.processingQueue = false;
        }
        this.myMap.compactIfNecessary();
        return processed;
    }

    V removeKey(@NotNull Key<K> key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(3);
        }
        return this.myMap.remove(key);
    }

    @NotNull
    Key<K> createKey(@NotNull K key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(4);
        }
        Key<K> key2 = this.createKey(key, this.myStrategy, this.myReferenceQueue);
        if (key2 == null) {
            RefHashMap.$$$reportNull$$$0(5);
        }
        return key2;
    }

    V putKey(@NotNull Key<K> weakKey, V value) {
        if (weakKey == null) {
            RefHashMap.$$$reportNull$$$0(6);
        }
        return this.myMap.put(weakKey, value);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        this.myHardKeyInstance.set(key);
        boolean result2 = this.myMap.containsKey(this.myHardKeyInstance);
        this.myHardKeyInstance.clear();
        return result2;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        this.myHardKeyInstance.set(key);
        Object result2 = this.myMap.get(this.myHardKeyInstance);
        this.myHardKeyInstance.clear();
        return result2;
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(7);
        }
        this.processQueue();
        return this.putKey(this.createKey(key), value);
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(8);
        }
        this.processQueue();
        this.myHardKeyInstance.set(key);
        Object result2 = this.myMap.remove(this.myHardKeyInstance);
        this.myHardKeyInstance.clear();
        return result2;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            RefHashMap.$$$reportNull$$$0(9);
        }
        return entrySet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weakKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = RefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator2 = new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<Key<K>, V>> hashIterator;
                private MyEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = wk.get();
                        if (k == null) continue;
                        this.next = new MyEntry(ent, k, wk.hashCode(), RefHashMap.this.myStrategy);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    MyEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
            if (iterator2 == null) {
                EntrySet.$$$reportNull$$$0(0);
            }
            return iterator2;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            RefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            RefHashMap.this.myHardKeyInstance.set(e.getKey());
            HardKey key = RefHashMap.this.myHardKeyInstance;
            Object hv = RefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && RefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                RefHashMap.this.myMap.remove(key);
            }
            RefHashMap.this.myHardKeyInstance.clear();
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Key wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap$EntrySet", "iterator"));
        }
    }

    private static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;
        private final int myKeyHashCode;
        @NotNull
        private final TObjectHashingStrategy<K> myStrategy;

        private MyEntry(@NotNull Map.Entry<?, V> ent, @NotNull K key, int keyHashCode, @NotNull TObjectHashingStrategy<K> strategy) {
            if (ent == null) {
                MyEntry.$$$reportNull$$$0(0);
            }
            if (key == null) {
                MyEntry.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                MyEntry.$$$reportNull$$$0(2);
            }
            this.ent = ent;
            this.key = key;
            this.myKeyHashCode = keyHashCode;
            this.myStrategy = strategy;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEqual(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RefHashMap.keyEqual(this.key, e.getKey(), this.myStrategy) && MyEntry.valEqual(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return this.myKeyHashCode ^ (v == null ? 0 : v.hashCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "strategy";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap$MyEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HardKey
    implements Key<K> {
        private K myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public K get() {
            return this.myObject;
        }

        private void set(@NotNull K object) {
            if (object == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.myObject = object;
            this.myHash = RefHashMap.this.myStrategy.computeHashCode(object);
        }

        private void clear() {
            this.myObject = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.myObject;
            Object u = ((Key)o).get();
            return RefHashMap.keyEqual(t, u, RefHashMap.this.myStrategy);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap$HardKey", "set"));
        }
    }

    static interface Key<T> {
        public T get();
    }

    private class MyMap
    extends THashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, new TObjectHashingStrategy<Key<K>>(){

                @Override
                public int computeHashCode(Key<K> key) {
                    return key.hashCode();
                }

                @Override
                public boolean equals(Key<K> o1, Key<K> o2) {
                    return o1 == o2 || RefHashMap.keyEqual(o1.get(), o2.get(), RefHashMap.this.myStrategy);
                }
            });
        }

        @Override
        public void compact() {
            if (!RefHashMap.this.processingQueue) {
                super.compact();
            }
        }

        private void compactIfNecessary() {
            if (this._deadkeys > this._size && this.capacity() > 42) {
                this.compact();
            }
        }

        @Override
        protected void rehash(int newCapacity) {
            int oldCapacity = this._set.length;
            Object[] oldKeys = this._set;
            Object[] oldVals = this._values;
            this._set = new Object[newCapacity];
            this._values = new Object[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                Key k;
                Object key;
                Object o = oldKeys[i];
                if (o == null || o == REMOVED || (key = (k = (Key)o).get()) == null) continue;
                int index2 = this.insertionIndex(k);
                if (index2 < 0) {
                    this.throwObjectContractViolation(this._set[-index2 - 1], o);
                    if (key == this._set) {
                        throw new AssertionError();
                    }
                }
                this._set[index2] = o;
                this._values[index2] = oldVals[i];
            }
        }
    }
}

