/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InvocationEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GrayFilter;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.ui.DocumentAdapter;
import org.jetbrains.kotlin.com.intellij.ui.Gray;
import org.jetbrains.kotlin.com.intellij.ui.JBColor;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.JBHiDPIScaledImage;
import org.jetbrains.kotlin.com.intellij.util.NotNullProducer;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.RetinaImage;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.kotlin.com.intellij.util.ui.EdtInvocationManager;
import org.jetbrains.kotlin.com.intellij.util.ui.ImageUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;
import org.jetbrains.kotlin.com.intellij.util.ui.accessibility.ScreenReader;
import sun.java2d.SunGraphicsEnvironment;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final GrayFilter DEFAULT_GRAY_FILTER;
    private static final GrayFilter DARCULA_GRAY_FILTER;
    private static final Pattern CLOSE_TAG_PATTERN;
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color UNFOCUSED_SELECTION_COLOR;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    private static final Color BORDER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    public static final Border DEBUG_MARKER_BORDER;
    private static volatile Pair<String, Integer> ourSystemFontData;
    private static final Ref<Boolean> ourRetina;
    private static Boolean jreHiDPI;
    private static boolean jreHiDPI_earlierVersion;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Function.Mono<Component> COMPONENT_PARENT;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !Registry.is("linux.jdk.accessibility.atkwrapper.block")) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            LOG.info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    private UIUtil() {
    }

    public static boolean isJreHiDPI() {
        return UIUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable JBUI.ScaleContext ctx) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(ctx));
    }

    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI != null) {
            return jreHiDPI;
        }
        jreHiDPI = false;
        jreHiDPI_earlierVersion = true;
        if (SystemInfo.isLinux) {
            return false;
        }
        if (SystemInfo.isJetBrainsJvm) {
            try {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (ge instanceof SunGraphicsEnvironment) {
                    Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, "isUIScaleOn", new Class[0]);
                    jreHiDPI = (Boolean)m.invoke((Object)ge, new Object[0]);
                    jreHiDPI_earlierVersion = false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (SystemInfo.isMac) {
            jreHiDPI = !SystemInfo.isAppleJvm;
        }
        return jreHiDPI;
    }

    static boolean isJreHiDPI_earlierVersion() {
        UIUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListBackground() {
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            Color color = UIManager.getColor("List.background");
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type2) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type2);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(36);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type2);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(37);
        }
        return bufferedImage;
    }

    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        UIUtil.drawImage(g, image, x, y, -1, -1, observer);
    }

    @Deprecated
    public static void drawImage(Graphics g, Image image, int x, int y, int width, int height, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            int dstw = width;
            int dsth = height;
            if (width == -1 && height == -1) {
                dstw = ImageUtil.getUserWidth(image);
                dsth = ImageUtil.getUserHeight(image);
            }
            int srcw = ImageUtil.getRealWidth(image);
            int srch = ImageUtil.getRealHeight(image);
            g.drawImage(img, x, y, x + dstw, y + dsth, 0, 0, srcw, srch, observer);
        } else if (width == -1 && height == -1) {
            g.drawImage(image, x, y, observer);
        } else {
            g.drawImage(image, x, y, x + width, y + height, 0, 0, width, height, observer);
        }
    }

    public static void dispatchAllInvocationEvents() {
        while (UIUtil.dispatchInvocationEvent()) {
        }
    }

    public static boolean dispatchInvocationEvent() {
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return false;
        }
        try {
            event = eventQueue.getNextEvent();
            if (event instanceof InvocationEvent) {
                eventQueue.getClass().getDeclaredMethod("dispatchEvent", AWTEvent.class).invoke((Object)eventQueue, event);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.rethrowAllAsUnchecked(e.getCause());
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return true;
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FontUIResource getFontWithFallback(@Nullable String familyName, int style, int size) {
        Font fontWithFallback = new StyleContext().getFont(familyName, style, size);
        return fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(66);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        Float forcedScale = null;
        if (Registry.is("ide.ui.scale.override")) {
            forcedScale = Float.valueOf((float)Registry.get("ide.ui.scale").asDouble());
        } else if (SystemInfo.isLinux && !SystemInfo.isJetBrainsJvm) {
            float scale = UIUtil.getScreenScale();
            if (scale > 1.0f) {
                forcedScale = Float.valueOf(scale);
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
        }
        if (forcedScale != null) {
            font = font.deriveFont(12.0f * forcedScale.floatValue());
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        float scale = 1.0f;
        scale = dpi < 120 ? 1.0f : (dpi < 144 ? 1.25f : (dpi < 168 ? 1.5f : (dpi < 192 ? 1.75f : 2.0f)));
        return scale;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(76);
            }
            return jBIterable;
        }
        Container container2 = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container2.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(77);
        }
        return jBIterable;
    }

    static {
        UIUtil.blockATKWrapper();
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl3;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$1", "compute"));
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        DEFAULT_GRAY_FILTER = new GrayFilter(true, 70);
        DARCULA_GRAY_FILTER = new GrayFilter(true, 20);
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        UNFOCUSED_SELECTION_COLOR = Gray._212;
        ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
        INACTIVE_HEADER_COLOR = Gray._128;
        BORDER_COLOR = Color.LIGHT_GRAY;
        CONTRAST_BORDER_COLOR = new JBColor(new NotNullProducer<Color>(){
            final Color color = new JBColor(0x9B9B9B, 0x4B4B4B);

            @Override
            @NotNull
            public Color produce() {
                if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                    Gray gray = Gray.xC9;
                    if (gray == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return gray;
                }
                Color color = this.color;
                if (color == null) {
                    4.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$4", "produce"));
            }
        });
        SIDE_PANEL_BACKGROUND = new JBColor(new NotNullProducer<Color>(){
            final JBColor myDefaultValue = new JBColor(new Color(15133680), new Color(4080460));

            @Override
            @NotNull
            public Color produce() {
                Color color = UIManager.getColor("SidePanel.background");
                Color color2 = color == null ? this.myDefaultValue : color;
                if (color2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return color2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$5", "produce"));
            }
        });
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._223, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(new Function<Component, JBIterable<Component>>(){

            @Override
            public JBIterable<Component> fun(@NotNull Component c) {
                if (c == null) {
                    17.$$$reportNull$$$0(0);
                }
                JBIterable<Object> result2 = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
                if (c instanceof JComponent) {
                    JPopupMenu jpm;
                    JComponent jc = (JComponent)c;
                    Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
                    if (orphans != null) {
                        result2 = result2.append(orphans);
                    }
                    if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                        result2 = result2.append(Collections.singletonList(jpm));
                    }
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$17", "fun"));
            }
        });
        COMPONENT_PARENT = new Function.Mono<Component>(){

            @Override
            public Component fun(Component c) {
                return c.getParent();
            }
        };
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(DocumentEvent e) {
                Document document = e.getDocument();
                if (document instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (final UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ((UndoManager)listener).discardAllEdits();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 65: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: 
            case 93: 
            case 95: 
            case 96: 
            case 100: 
            case 102: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 65: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: 
            case 93: 
            case 95: 
            case 96: 
            case 100: 
            case 102: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 3: 
            case 15: 
            case 46: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 50: 
            case 52: 
            case 54: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 94: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 17: 
            case 35: 
            case 60: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 19: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 65: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: 
            case 93: 
            case 95: 
            case 96: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 24: 
            case 25: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 51: 
            case 53: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 55: 
            case 58: 
            case 62: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 59: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 66: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 98: 
            case 99: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignSource";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStrokes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 82: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientPaint";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawFramingLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 19: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 65: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: 
            case 93: 
            case 95: 
            case 96: 
            case 100: 
            case 102: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "paintWithXorOnRetina";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findParentByClass";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 80: 
            case 81: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignBorder";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "redirectKeystrokes";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 65: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: 
            case 93: 
            case 95: 
            case 96: 
            case 100: 
            case 102: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JBHtmlEditorKit
    extends HTMLEditorKit {
        private final StyleSheet style;

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        public static StyleSheet createStyleSheet() {
            StyleSheet style = new StyleSheet();
            style.addStyleSheet(UIUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : DEFAULT_HTML_KIT_CSS);
            style.addRule("code { font-size: 100%; }");
            style.addRule("small { font-size: small; }");
            return style;
        }

        @Override
        public void install(final JEditorPane pane) {
            super.install(pane);
            if (pane != null) {
                pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Font font = UIUtil.getLabelFont();
                        assert (font instanceof FontUIResource);
                        if (SystemInfo.isWindows) {
                            font = UIUtil.getFontWithFallback("Tahoma", font.getStyle(), font.getSize());
                        }
                        pane.setFont(font);
                        pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                        pane.removePropertyChangeListener(this);
                    }
                });
            }
        }
    }

    static final class DetectRetinaKit {
        private static final Map<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = ContainerUtil.createWeakMap();

        static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            if (SystemInfo.isAppleJvm) {
                return false;
            }
            Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (Exception e) {
                LOG.debug(e);
                LOG.debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("object is not an instance of declaring class: " + device.getClass().getName());
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put(device, isRetina);
            return isRetina;
        }
    }
}

