/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskPlanExecutor
implements TaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;
    private final WorkerLeaseService workerLeaseService;
    private final BuildCancellationToken cancellationToken;
    private final ResourceLockCoordinationService coordinationService;

    public DefaultTaskPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        this.executorFactory = executorFactory;
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker) {
        ManagedExecutor executor = this.executorFactory.create("Task worker for '" + taskExecutionPlan.getDisplayName() + "'");
        try {
            WorkerLeaseRegistry.WorkerLease parentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
            this.startAdditionalWorkers(taskExecutionPlan, taskWorker, (Executor)executor, parentWorkerLease);
            new TaskExecutorWorker(taskExecutionPlan, taskWorker, parentWorkerLease, this.cancellationToken, this.coordinationService).run();
            this.awaitCompletion(taskExecutionPlan);
        }
        finally {
            executor.stop();
        }
    }

    private void awaitCompletion(final TaskExecutionPlan taskExecutionPlan) {
        this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (taskExecutionPlan.allTasksComplete()) {
                    taskExecutionPlan.rethrowFailures();
                    return ResourceLockState.Disposition.FINISHED;
                }
                return ResourceLockState.Disposition.RETRY;
            }
        });
    }

    private void startAdditionalWorkers(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, Executor executor, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
        LOGGER.debug("Using {} parallel executor threads", (Object)this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            executor.execute(new TaskExecutorWorker(taskExecutionPlan, taskWorker, parentWorkerLease, this.cancellationToken, this.coordinationService));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final Action<? super TaskInternal> taskWorker;
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private final BuildCancellationToken cancellationToken;
        private final ResourceLockCoordinationService coordinationService;

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, WorkerLeaseRegistry.WorkerLease parentWorkerLease, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskWorker = taskWorker;
            this.parentWorkerLease = parentWorkerLease;
            this.cancellationToken = cancellationToken;
            this.coordinationService = coordinationService;
        }

        @Override
        public void run() {
            final AtomicLong busy = new AtomicLong(0L);
            Timer totalTimer = Time.startTimer();
            final Timer taskTimer = Time.startTimer();
            WorkerLeaseRegistry.WorkerLease childLease = this.parentWorkerLease.createChild();
            boolean moreTasksToExecute = true;
            while (moreTasksToExecute) {
                moreTasksToExecute = this.executeWithTask(childLease, new Action<TaskInternal>(){

                    public void execute(TaskInternal task) {
                        String taskPath = task.getPath();
                        LOGGER.info("{} ({}) started.", (Object)taskPath, (Object)Thread.currentThread());
                        taskTimer.reset();
                        TaskExecutorWorker.this.taskWorker.execute((Object)task);
                        long taskDuration = taskTimer.getElapsedMillis();
                        busy.addAndGet(taskDuration);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("{} ({}) completed. Took {}.", new Object[]{taskPath, Thread.currentThread(), TimeFormatting.formatDurationVerbose((long)taskDuration)});
                        }
                    }
                });
            }
            long total = totalTimer.getElapsedMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task worker [{}] finished, busy: {}, idle: {}", new Object[]{Thread.currentThread(), TimeFormatting.formatDurationVerbose((long)busy.get()), TimeFormatting.formatDurationVerbose((long)(total - busy.get()))});
            }
        }

        private boolean executeWithTask(final WorkerLeaseRegistry.WorkerLease workerLease, Action<TaskInternal> taskExecution) {
            final AtomicReference selected = new AtomicReference();
            final AtomicBoolean workRemaining = new AtomicBoolean();
            this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    if (TaskExecutorWorker.this.cancellationToken.isCancellationRequested()) {
                        TaskExecutorWorker.this.taskExecutionPlan.cancelExecution();
                    }
                    workRemaining.set(TaskExecutorWorker.this.taskExecutionPlan.hasWorkRemaining());
                    if (!workRemaining.get()) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    try {
                        selected.set(TaskExecutorWorker.this.taskExecutionPlan.selectNextTask(workerLease, resourceLockState));
                    }
                    catch (Throwable t) {
                        resourceLockState.releaseLocks();
                        TaskExecutorWorker.this.taskExecutionPlan.abortAllAndFail(t);
                        workRemaining.set(false);
                    }
                    if (selected.get() == null && workRemaining.get()) {
                        return ResourceLockState.Disposition.RETRY;
                    }
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            TaskInfo selectedTask = (TaskInfo)selected.get();
            if (selectedTask != null) {
                this.execute(selectedTask, workerLease, taskExecution);
            }
            return workRemaining.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(TaskInfo selectedTask, WorkerLeaseRegistry.WorkerLease workerLease, Action<TaskInternal> taskExecution) {
            block4: {
                try {
                    if (selectedTask.isComplete()) break block4;
                    try {
                        taskExecution.execute((Object)selectedTask.getTask());
                    }
                    catch (Throwable e) {
                        selectedTask.setExecutionFailure(e);
                    }
                }
                catch (Throwable throwable) {
                    this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(selectedTask, workerLease){
                        final /* synthetic */ TaskInfo val$selectedTask;
                        final /* synthetic */ WorkerLeaseRegistry.WorkerLease val$workerLease;
                        {
                            this.val$selectedTask = taskInfo;
                            this.val$workerLease = workerLease;
                        }

                        public ResourceLockState.Disposition transform(ResourceLockState state) {
                            TaskExecutorWorker.this.taskExecutionPlan.taskComplete(this.val$selectedTask);
                            return (ResourceLockState.Disposition)DefaultResourceLockCoordinationService.unlock((ResourceLock[])new ResourceLock[]{this.val$workerLease}).transform((Object)state);
                        }
                    });
                    throw throwable;
                }
            }
            this.coordinationService.withStateLock((Transformer)new /* invalid duplicate definition of identical inner class */);
        }
    }
}

